#include "mbed.h"
#include "figs.h" 

SPI deviceM(PB_15, PB_14, PB_13);
DigitalOut ssel (PB_12);         
Serial device(USBTX,USBRX);
#define  VEL 80
uint8_t matrix_act[11]={0,0,0,0,0,0,0,0,0,0,0};    
uint8_t matrix_tmp[8]={0,0,0,0,0,0,0,0};    
uint8_t matrix_tmp1[8]={0,0,0,0,0,0,0,0};
uint8_t fila=0,i=0, cont=0, ncolumna=1, grados=0, output1=0;


void Rx_interrupt() {
    output1=!output1;
    char d = device.getc(); //obtiene lo que hay en el puerto serial
    
    device.printf("irq %c\n",d);//hace el cambio en el led 
    void correr_fig();
    return;
}
  
void sendSPI(uint8_t d1, uint8_t d2)
{
    deviceM.unlock();
    ssel=0;
    deviceM.write(d1); 
    deviceM.write(d2);
    ssel=1;
    deviceM.lock();
}

void init_display() 
{
sendSPI(0x0c,1);
    sendSPI(0x0b,7);
    sendSPI(0x09,0);
    sendSPI(0x0A,0x0E);
    int j;
    for (j=0;j<4;j++){
        sendSPI(0x0F,1);
        wait (0.2);
        sendSPI(0x0f,0);
        wait (0.2);
    }   
}

void copy_matrix(uint8_t a,uint8_t b,uint8_t c,uint8_t* fig,uint8_t columna)
{       
        matrix_tmp[0]= *(fig+5)>>columna-1;             
        matrix_tmp[1]= *(fig+a)>>columna-1;
        matrix_tmp[2]= *(fig+b)>>columna-1;
        matrix_tmp[3]= *(fig+c)>>columna-1;       
}

void clean_mat() 
{
    int j;
    for(j=0;j<=8;j++)
    {
        sendSPI(0x0+j,0x00);
    }
};

void buscar_fil(){
    for (uint8_t j=0;j<9;j++){                     
        if((matrix_act[j]& matrix_tmp[3])==0){
        fila=j;
        }
        if((matrix_act[j]& matrix_tmp[3])!=0){
        fila=j-1;                                   
        j=9;
        }
        if((matrix_act[j]& matrix_tmp[2])!=0){            
        fila=j;                                   
        j=9;
        }
        if((matrix_act[j]& matrix_tmp[1])!=0){
        fila=j+1;                                   
        j=9;
        }
    }
    if(fila>8)
    fila=8;
    
};

void guardar_mat(){
        matrix_act[fila-3]=matrix_tmp1[0];
        matrix_act[fila-2]=matrix_tmp1[1];
        matrix_act[fila-1]=matrix_tmp1[2];     
        matrix_act[fila]=matrix_tmp1[3];       
    };


void imp_mat(uint8_t *temp){                             
    buscar_fil();
    for (int j=0;j<=fila;j++){
        matrix_tmp1[0]=(matrix_tmp[0]+ matrix_act[j-3]);
        matrix_tmp1[1]=(matrix_tmp[1]+ matrix_act[j-2]);
        matrix_tmp1[2]=(matrix_tmp[2]+ matrix_act[j-1]);
        matrix_tmp1[3]=(matrix_tmp[3]+ matrix_act[j]);                              
        sendSPI(j-3,matrix_tmp1[0]);
        sendSPI(j-2,matrix_tmp1[1]);
        sendSPI(j-1,matrix_tmp1[2]);
        sendSPI(j  ,matrix_tmp1[3]);                    
        wait_ms(VEL);
        }
}
void correr_fig(){
    
    uint8_t correr=device.getc();
    
    if(correr==30)  
    correr=1;
    
    if(correr==29)  
    correr=2;
    
    if(correr==28)
    correr=3;
    
    if(correr==31) 
    correr=0;
    
    switch (correr){
               /* 
                case 0:
                cont++;
                if(cont>8)cont=8;
                break;*/                                                    
                
                case 1:
                if( (matrix_tmp[1]==2) || (matrix_tmp[1]==1)|| (matrix_tmp[1]==3)) 
                ncolumna--;
                grados++;
                if(grados>4)
                grados=1;
                break;                                                    
                
                case 2:
                if((matrix_tmp[2]==7 || matrix_tmp[3]==7)||(matrix_tmp[2]==3 && matrix_tmp[3]==6)) {
                    device.printf("a");
                    ncolumna=6;
                    }
                else if((matrix_tmp[1]==2 && matrix_tmp[2]==2 && matrix_tmp[3]==2)){
                    device.printf("b");
                    ncolumna=8;
                    }
                else if (ncolumna<7){
                    device.printf("c");
                    ncolumna++;
                    }
                break;
                    
                case 3:
                ncolumna--;
                if(ncolumna<1)
                ncolumna=1;
                break;                                                   
                }
    
    }


void new_fig(char type_fig,char grados,char columna)
{    
    switch (type_fig){                  
        case 1: if(columna>7)
                columna=7;
                copy_matrix(5,1,1,PLANT,columna); break;  
        
        case 2: if(grados==1 || grados==3)              
                copy_matrix(0,0,0,PLANT,columna);
                if(grados==2 || grados==4)
                copy_matrix(5,5,2,PLANT,columna);            
                break;
                  
        case 3: if(grados==1)
                copy_matrix(0,0,1,PLANT,columna);         
                if(grados==2)
                copy_matrix(5,2,0,PLANT,columna);
                if(grados==3)
                copy_matrix(1,3,3,PLANT,columna);
                if(grados==4)
                copy_matrix(5,6,2,PLANT,columna);
                break;                                  
        
        case 4: if(grados==1)
                copy_matrix(5,3,2,PLANT,columna);         
                if(grados==2)
                copy_matrix(0,1,0,PLANT,columna);
                if(grados==3)
                copy_matrix(5,2,3,PLANT,columna);
                if(grados==4)
                copy_matrix(3,1,3,PLANT,columna);
                break;
        
        case 5: if(grados==1 || grados==3)
                copy_matrix(5,4,1,PLANT,columna);   
                if(grados==2 || grados==4)
                copy_matrix(0,1,3,PLANT,columna);
                break; 
    }  
}

int main() {
    char tipo_fig=1,ncolumna=1,grados=1,lee1=0,lee2=0;  
    init_display();
    clean_mat();
    while(1){
        lee1=device.getc();                
        tipo_fig=device.getc();
        grados=device.getc();
        ncolumna=device.getc();       
        lee2=device.getc();                
            if(lee1==0x3c && lee2==0x3e)    
            {
            new_fig(tipo_fig,grados,ncolumna);
            imp_mat(matrix_tmp);
            guardar_mat();
            }     
        }
    }