
#include "mbed.h"
//#include "max7219.h"

// ***************************************************************************
// option 1 : use  SPI
// ***************************************************************************
SPI deviceM(PB_15, PB_14, PB_13);
DigitalOut ssel (PB_12);

#define  uint8_t unsigned char
uint8_t vcol2[8]={0,0,0,0,0,0,0,0};

 
void sendSPI(uint8_t d1, uint8_t d2)
{
    deviceM.unlock();
    ssel=0;
    deviceM.write(d1); 
    deviceM.write(d2);  
    ssel=1;
    deviceM.lock();
};


void printMatrix(uint8_t*  vC)

{
    uint8_t i =0;
    for (i=1;i<9;i++){
        sendSPI(i,*(vC+i));
    }
        
    };

void reset_vcol()
    {
    for (i=0; i<8;i++){
            vcol2[i]=0;
    }
    
}   
 
void print_Snake2()
{
    
    int j, i;
      //reset
    reset_vcol();
    for (j=0; j<8;j++){
        for (i=0; i<8;i++){
            if(j % 2 == 0){
                if (vcol2[j]==0)
                    vcol2[j]= 1;
                vcol2[j]=3>>i;
                }
            else{
                if (vcol2[j]==0x80)
                    vcol2[j]= 1;
                vcol2[j]=3>>i;
                }
            printMatrix(vcol2);
            wait_ms(5);
            }
        }
}

void print_Snake()
{
       
    uint8_t vt1[8]={1,3,7,0xf,0x1f,0x3f, 0x7f,0xff};
    uint8_t vt2[8]={0b10000000,0b11000000,0b11100000,0b11110000,0b11111000,0b11111100,0b11111110,0b11111111};
    
      
    int j, i;
      //reset
    reset_vcol();
    for (j=0; j<8;j++){
        for (i=0; i<8;i++){
            if(j % 2 == 0){
                vcol2[j]=vt1[i];
            }else{
                vcol2[j]=vt2[i];
            }
            printMatrix(vcol2);
            wait_ms(5);
        }
        }    
}   
int main() {
                    uint8_t vcol[8]={0,0,0,0,0,0,0,0};
                    sendSPI(0x0c,1);
                    sendSPI(0x0F,1);
                    wait (0.1);
                    sendSPI(0x0f,0);
                    wait (0.1);
                    int i =0;
                    while(1){
                        print_Snake();
                        }
}
// ***************************************************************************
// option two: use maz7219 library

// ***************************************************************************    
/*
Max7219 deviceM(PB_15, PB_14, PB_13, PB_12);


int main() {
    
    max7219_configuration_t cfg = {
    .device_number = 1,
    .decode_mode = 0,
    .intensity = Max7219::MAX7219_INTENSITY_8,
    .scan_limit = Max7219::MAX7219_SCAN_8
};
   
    deviceM.init_device(cfg);
    
    deviceM.enable_device(1);
   
    deviceM.set_display_test();
    wait(1);   
   deviceM.clear_display_test();
    wait(1);
  
    while(1){
         deviceM.write_digit(1,8,0b11111111);
         deviceM.write_digit(1,1,0b01010101);
         deviceM.write_digit(1,2,0b10101010);
         deviceM.write_digit(1,3,0b01010101);
         deviceM.write_digit(1,4,0b10101010);
         deviceM.write_digit(1,5,0b01010101);
         deviceM.write_digit(1,6,0b10101010);
         deviceM.write_digit(1,7,0b01010101);
        }
}
*/

