
#include "mbed.h"
#include "figuras.h"

SPI deviceM(PB_15, PB_14, PB_13);
DigitalOut ssel (PB_12);
Serial command(USBTX, USBRX);

#define DEBUG 1
#define  VELOCITY 1000 // ms



uint8_t matrix_act[8]={0,0,0,0,0,0,0,0};
uint8_t matrix_tmp[11]={0b00000000,0b00000000,0b00000000,0,0,0,0,0,0,0};
  
 
void sendSPI(uint8_t d1, uint8_t d2)
{
    deviceM.unlock();
    ssel=0;
    deviceM.write(d1); 
    deviceM.write(d2);  
    ssel=1;
    deviceM.lock();
};




void debug_m(char *s , ... ){
    #if DEBUG
    command.printf(s);
    #endif  
}

void printMatrix(uint8_t*  vC)

{
    uint8_t i =0;
    for (i=1;i<9;i++){
        sendSPI(i,*(vC+i-1));
    }
        
    }


void init_display(){
    sendSPI(0x0c,1);
    sendSPI(0x0b,7);
    sendSPI(0x09,0);
    sendSPI(0x0A,0x0E);
    printMatrix(matrix_act);
    int i;
    for (i=0;i<4;i++){
        sendSPI(0x0F,1);
        wait (0.2);
        sendSPI(0x0f,0);
        wait (0.2);
    }
}



 
void act_matrix(uint8_t*  mascara){ 
    for (int i=0; i<8;i++)
        matrix_act[i]=  ( *(mascara+i));
 
 } 
 void copy_matrix(uint8_t*  m2, char col){
  
    for (int i=0; i<11;i++){
        matrix_tmp[i]=  (*(m2+i)>>col);
    }
 } 

    
void new_read(){
    
    char ini=command.getc();
    char tf=command.getc();
    char ang=command.getc();
    char col=command.getc();
    char fin=command.getc();
    if(ini==0x3C && fin==0x3E)
    {
    switch (tf) {
    case  L_TYPE: 
    switch (ang)
         {  case NOVEN:
            copy_matrix(FIG_L1);
            break;
            case ZERO:
            copy_matrix(FIG_L);
        break ; 
        case PII:
            copy_matrix(FIG_L2);
            break;
            case DOSSE:
            copy_matrix(FIG_L3);
            break; 
        }
        break ;     
    case  S_TYPE: 
        switch (ang)
         {  case NOVEN:
            copy_matrix(FIG_S1);
            break;
            case ZERO:
            copy_matrix(FIG_S);
        break ; 
        case PII:
            copy_matrix(FIG_S2);
            break;
            case DOSSE:
            copy_matrix(FIG_S3);
            break; 
        }
        break ;     
    case  I_TYPE: 
        switch (ang)
         {  case NOVEN:
            copy_matrix(FIG_I1);
            break;
            case ZERO:
            copy_matrix(FIG_I);
        break ; 
        case PII:
            copy_matrix(FIG_I2);
            break;
            case DOSSE:
            copy_matrix(FIG_I3);
            break; 
        }
        break ;     
    case  C_TYPE: 
        copy_matrix(FIG_C);
        break ; 
    case  T_TYPE:
         switch (ang)
         {  case NOVEN:
            copy_matrix(FIG_T1);
            break;
            case ZERO:
            copy_matrix(FIG_T);
        break ; 
        case PII:
            copy_matrix(FIG_T2);
            break;
            case DOSSE:
            copy_matrix(FIG_T3);
            break; 
        }
        break;
    default: 
        copy_matrix(FIG_NULL);
        break;
        }
        }
        else
        {}
}
//desplazamiento horizontal
void desplazar_fila(){
    for (int i=0; i<8;i++)
        matrix_tmp[i]= matrix_tmp[i]>>1;
    
    }


int main() {
    init_display();
    while(1){
       new_read();
           for(int i=0;i<8;i++){
            desplazar_fila();
            act_matrix(matrix_tmp);
            printMatrix(matrix_act);
            wait_ms(VELOCITY);
       }  
       } 
    }
