#include "mbed.h"
// Bits are: Start (1), SGL/DIFF (1 for single), ODD/SIGN (0 for channel 0), MSBF (1 for MSB first)
#define MCP3002_CH0 0x68  // 0110 1000
#define MCP3002_CH1 0x78  // 0111 1000

Serial pc(USBTX, USBRX);
SPI spi(p5, p6, p7); // mosi, miso, sclk
DigitalOut cs(p20); // Chip select, active low
AnalogOut aout(p18);

// Note that using CS means that the chip itself has no address

int main() {
    pc.printf("Starting program \r\n");
    // Chip must be deselected
    cs = 1;
    // Setup the spi for 8 bit data, CPOL = 0, CPHA = 0
    // with a 10KHz clock rate
    spi.format(8,0);
    spi.frequency(10000);
    int data1, data2, mask, channel;
    aout = 0.0;
    // Supply voltage is nominally 3.3V
    float VCC=3.3, vIn;
    while(1) {
        for (channel = 0; channel<2; channel++){
            if(channel == 0){
                mask = MCP3002_CH0;
            }else{
                mask = MCP3002_CH1;
            }     
            cs = 0;
            data1 = spi.write(mask);
            cs = 1;
            data2 = spi.write(0);
            //cs = 1;
// Format for MSB set
            data1 &= 0x03;  // keep only three bits
            data2 |= data1 << 8 ; // shift and add to LSB
// data2 ranges from 0 to 1023 for voltage from 0 to VCC
            vIn = VCC*data2/1000.;
            pc.printf("Channel %i Voltage is %f \r\n",channel,vIn);
        }
        aout = aout + 0.1;
        float volt = aout;
        pc.printf("Analog output of mbed is %f \r\n", volt);
        //wait(1);
    }
}
