#include "mbed.h"

#define MCP9808_ADDR     (0x30) // MCP9808 base address 0x18<<1
#define MCP9808_REG_TEMP (0x05) // Temperature Register
#define MCP9808_REG_CONF (0x01) // Configuration Register
#define MCP9808_REG_CRIT (0x04) // Critical Temperature Register


LocalFileSystem local("local");               // Create the local filesystem under the name "local"
// create an empty file pointer.
FILE *myLogFile = NULL;

Serial pc(USBTX, USBRX);
I2C i2c(p9, p10);   // SDA, SCL on MCP9808
// Note MCP9808 also needs VCC (3.3 V) and GND

float TempValue;
float data[20];
char data_write[3], data_read[2];
int ii, status;
int main() {
    char text[128];
    pc.printf("Program will start when you enter a number\r\n");
    pc.scanf("%s", text);
    pc.printf("Printing all filenames:\r\n");
    char fname[128];
    DIR* dir = opendir("/local/");
    struct dirent* de;
    while((de = readdir(dir)) != NULL){
        pc.printf("  %s\r\n", &(de->d_name)[0]);
    }
    // Wake up
    data_write[0] = MCP9808_REG_CONF; // Register address
    data_write[1] = 0x00;  // Data MSB, b11-15 not used, b9-10 =>T_HYS=0, b8 => continuous conversions
    data_write[2] = 0x1C;  // Data LSB,  Alert Off, Alert Disabled, Alert T>T_Crit, Alert active low, Alert interrupt
    status = i2c.write(MCP9808_ADDR, data_write, 3, 0); // address,data,length,repeat
    // address is chip addess
    // First byte of data has register address 
    // repeat true for multiple write when the chip autoincrements the address
    // MCP9808 does not do this, so we leave it at 0
     
    data_write[0] = MCP9808_REG_CRIT; // Register address
    data_write[1] = 0x01;  
    data_write[2] = 0x70;  
    status = i2c.write(MCP9808_ADDR, data_write, 3, 0); // address,data,length,repeat
 
    while(1){
        int i=0;
        // this loops takes 10 data points and then
        // appends those data points to a file
        while(i<10){
        // Read temperature  
            data_write[0] = MCP9808_REG_TEMP;
            i2c.write(MCP9808_ADDR, data_write, 1, 1); // no stop
            i2c.read(MCP9808_ADDR, data_read, 2, 0);
            status = data_read[0] >> 5;  // Shift flags to b0-b2
            // 1 in flag means: T>T_crit(b2), T>T_Upper(b1), T<T_Lower(b0)
            pc.printf("the status is %d\n\r",status);
           
           
            data_read[0] = data_read[0] & 0x1F;  // clear flag bits for temperature
            
            data[i] = (data_read[0] * 16) + (data_read[1] / 16.0); // combine two bytes
            // Display the flags, if you wish
            // pc.printf("Flags are %i \n\r",status);
            // This displays to the user
            float temperature_fahr = data[i]*(9.0/5)+32;
            pc.printf("%i Celsius temperature is %3.1f\n\r",i,data[i]);
            pc.printf("%i Fahrenheit temperature is %3.1f\n\r",i,temperature_fahr);
            i=i+1;
            wait(1);
            
            if (data_read[0] > 24){
                
            }
        }
                
        myLogFile = fopen("/local/log.txt", "a"); // open log.txt as a write only file (any existing file will be overwritten). Replace "w" with "a" to append
        if (myLogFile == NULL) {  // check the file is open.
            pc.printf("Couldn't open the log file.");
            while (1) {
                wait(10);
            }
        }
        else{
            for( ii = 0; ii < 10; ii++ ){
                fprintf(myLogFile, "Index %i Temperature is %3.1f\r\n",ii,data[ii]);
            }
            fclose(myLogFile);
        }
    }
}
