#include "mbed.h"
#include "mb_pins.h"
#include "platform/mbed_thread.h"
#include "MQTTClientMbedOs.h"

#include "Adafruit_GFX.h"
#include "Adafruit_GFX_Config.h"
#include "Adafruit_SSD1306.h"



#define SMALL_WAIT_MS 10
#define VOLTAGE_SCALER 3.3f

//I2C adress
#define I2C_ADDRESS         0x3c
#define I2C_ADD_MBED    I2C_ADDRESS << 1

//OLED DIMENSIONS
#define OLED_HEIGHT_PX 64
#define OLED_WIDTH_PX 128

// Pointer to a WiFi network object:
WiFiInterface *wifi;
// Creating TCP socket:
TCPSocket socket;
// Creating MQTT client using the TCP socket;
MQTTClient client(&socket);
// Message handler:
MQTT::Message message;
const char* topic_sub = "subpim";
const char* topic_pub = "pubpim";
// HiveMQ broker connectivity information:
const char* hostname = "broker.hivemq.com";
const int port = 1883;


void messageArrived(MQTT::MessageData& md)
{
    MQTT::Message &msg = md.message;
    printf("Browser message: %.*s \n", msg.payloadlen, (char*)msg.payload);
    message.qos = MQTT::QOS0;
    message.retained = false;
    message.dup = false;
    message.payload = (void*)msg.payload;
    message.payloadlen = msg.payloadlen + 1;
    client.publish(topic_pub, message);  
}

int main()
{
    wifi = WiFiInterface::get_default_instance();
    if (!wifi) {
        printf("ERROR: No WiFiInterface found.\n");
        return -1;
    }
    
    printf("Connecting to %s... \n",MBED_CONF_APP_WIFI_SSID);
    int ret = wifi->connect(MBED_CONF_APP_WIFI_SSID, MBED_CONF_APP_WIFI_PASSWORD, NSAPI_SECURITY_WPA_WPA2);
    if(ret != 0){
        printf("\nConnection error: %d\n", ret);
        return -1;
    }
    printf("Connected to %s\n", MBED_CONF_APP_WIFI_SSID);
    socket.open(wifi);
    socket.connect(hostname,port);
    MQTTPacket_connectData data = MQTTPacket_connectData_initializer;
    data.MQTTVersion = 3;
    data.clientID.cstring = "pim-27";
    client.connect(data);
    client.subscribe(topic_sub, MQTT::QOS0, messageArrived);
    
    while(1) {
        thread_sleep_for(SMALL_WAIT_MS);
        client.yield(1000);
    }
}
