#include "mbed.h"
#include "uLCD_4DGL.h"
#include "LSM9DS1.h"
#include "SongPlayer.h"
#include "SDFileSystem.h"
#include "wave_player.h"

uLCD_4DGL uLCD(p28,p27,p30); // serial tx, serial rx, reset pin;
SDFileSystem sd(p5, p6, p7, p8, "sd"); // DI, DO, SCK, CS
DigitalIn dummy1(p18); // sets p18 to high Z

float note[2]= {1168.0,0.0};
float duration[2]= {0.2,0.0};

int main()
{
    SongPlayer mySpeaker(p21); // PwmOut
    LSM9DS1 IMU(p9, p10, 0xD6, 0x3C);
    uLCD.background_color(WHITE);
    uLCD.cls();
    IMU.begin();
    if (!IMU.begin()) uLCD.printf("Failed to communicate with LSM9DS1.\n");
    int radius=2;
    int x=66;
    int y=10;
    int dir=1;
    int u=1;
    int bounce_pos=0;
    int rect_x1 = floor(105*(rand()/(float(RAND_MAX))));
    int rect_x2 = floor(52*(rand()/(float(RAND_MAX))));
    int rect_x3 = floor(26*(rand()/(float(RAND_MAX))));
    int rect_x4 = floor(13*(rand()/(float(RAND_MAX))));
    int rect_y1 = 90;
    int rect_y2 = 65;
    int rect_y3 = 40;
    int rect_y4 = 10;

    // Initialize first several platforms
    uLCD.filled_rectangle(rect_x1,rect_y1,rect_x1+20,rect_y1+4,GREEN);
    uLCD.filled_rectangle(rect_x2,rect_y2,rect_x2+20,rect_y2+4,GREEN);
    uLCD.filled_rectangle(rect_x3,rect_y3,rect_x3+20,rect_y3+4,GREEN);
    uLCD.filled_rectangle(rect_x4,rect_y4,rect_x4+20,rect_y4+4,GREEN);
    while(1) {
        wait(0.005);
        
        //erase old ball location
        uLCD.filled_circle(x, y, radius, WHITE);
        
        // read in tilt
        IMU.readAccel();
        
        // update and draw new ball
        x = 66 + 63*IMU.calcAccel(IMU.ax);
        if( y<(bounce_pos-36) ) {
            dir = -dir;
        }
        u = abs(floor((y-bounce_pos + 36)/9.0)) + 1;
        y = y + dir*u; // u (very roughly) models gravity
        uLCD.filled_circle(x, y, radius, RED);

        // Bounce event
        if( ((x>=rect_x1 && x<=(rect_x1+20) && y>=(rect_y1-1) && y<=(rect_y1+4)) ||
                (x>=rect_x2 && x<=(rect_x2+20) && y>=(rect_y2-1) && y<=(rect_y2+4)) ||
                (x>=rect_x3 && x<=(rect_x3+20) && y>=(rect_y3-1) && y<=(rect_y3+4)) ||
                (x>=rect_x4 && x<=(rect_x4+20) && y>=(rect_y4-1) && y<=(rect_y4+4))) && dir == 1 ) {
            mySpeaker.PlaySong(note,duration);
            bounce_pos = y;
            dir = -dir;
            // Erase old platforms
            uLCD.filled_rectangle(rect_x1,rect_y1,rect_x1+20,rect_y1+4,WHITE);
            uLCD.filled_rectangle(rect_x2,rect_y2,rect_x2+20,rect_y2+4,WHITE);
            uLCD.filled_rectangle(rect_x3,rect_y3,rect_x3+20,rect_y3+4,WHITE);
            uLCD.filled_rectangle(rect_x4,rect_y4,rect_x4+20,rect_y4+4,WHITE);
            // Update and draw new platforms
            rect_y1 += 20;
            rect_y2 += 20;
            rect_y3 += 20;
            rect_y4 += 20;
            uLCD.filled_rectangle(rect_x1,rect_y1,rect_x1+20,rect_y1+4,GREEN);
            uLCD.filled_rectangle(rect_x2,rect_y2,rect_x2+20,rect_y2+4,GREEN);
            uLCD.filled_rectangle(rect_x3,rect_y3,rect_x3+20,rect_y3+4,GREEN);
            uLCD.filled_rectangle(rect_x4,rect_y4,rect_x4+20,rect_y4+4,GREEN);
        }

        // Recycle platforms as they come off screen
        if( rect_y1 >128) {
            rect_y1 = floor(15*(rand()/(float(RAND_MAX))));
            rect_x1 = floor(105*(rand()/(float(RAND_MAX))));
            uLCD.filled_rectangle(rect_x1,rect_y1,rect_x1+20,rect_y1+4,GREEN);
        }
        if( rect_y2 >128) {
            rect_y2 = floor(15*(rand()/(float(RAND_MAX))));
            rect_x2 = floor(105*(rand()/(float(RAND_MAX))));
            uLCD.filled_rectangle(rect_x2,rect_y2,rect_x2+20,rect_y2+4,GREEN);
        }

        if( rect_y3 >128) {
            rect_y3 = floor(15*(rand()/(float(RAND_MAX))));
            rect_x3 = floor(105*(rand()/(float(RAND_MAX))));
            uLCD.filled_rectangle(rect_x3,rect_y3,rect_x3+20,rect_y3+4,GREEN);
        }
        if( rect_y4 >128) {
            rect_y4 = floor(15*(rand()/(float(RAND_MAX))));
            rect_x4 = floor(105*(rand()/(float(RAND_MAX))));
            uLCD.filled_rectangle(rect_x4,rect_y4,rect_x4+20,rect_y4+4,GREEN);
        }

        // Ball falls off screen
        if(y>128) break;
        
    }

    // print GAME OVER
    uLCD.cls();
    uLCD.color(BLUE);
    uLCD.textbackground_color(WHITE);
    uLCD.locate(4,4);
    uLCD.text_width(2);
    uLCD.text_height(2);
    uLCD.printf("GAME");
    uLCD.locate(2,4);
    uLCD.printf("OVER%\n");
    // play GAME OVER sound
    FILE *wave_file;
    DigitalIn dummy2(p21); // set p21 to high Z
    AnalogOut DACout(p18); // AnalogOut
    wave_player waver(&DACout);
    wave_file=fopen("/sd/wavfiles/BOMB.wav","r");
    waver.play(wave_file);
    fclose(wave_file);
    wait(500);
}
