#include "mbed.h"

DigitalOut leds[] = {(LED1), (LED2), (LED3), (LED4) };
AnalogIn photo(p19);
DigitalIn button(p16);
Serial pc(USBTX, USBRX);
LocalFileSystem local("local");
Timer timer;

FILE* fp = NULL;
char filename[256];

int n_leds, i, saving, filecount = 0;
float voltage;

int main (void) {
    timer.start();
    while(true) {
        voltage = 3.3*photo;
        n_leds = (int)(4*(voltage - 2.0));
        
        for (i=0; i<4; i++) {
            leds[i] = (i < n_leds) ? 1 : 0;
        }
        
        saving = button ? 1 : 0;
        
        printf("%f %d %d\r\n", voltage, n_leds, saving);
        
        if (saving) {
            if (fp == NULL) {
                sprintf(filename,"/local/%d.txt",timer.read_ms());
                fp = fopen(filename,"w");
            } else {
                fprintf(fp, "%f\r\n", voltage);
            }
        } else {
            if (fp != NULL) {
                fclose(fp);
                fp = NULL;
                filecount++;
            }
        }
        
        if (filecount >= 3) {
            exit(0);
        }
        wait(0.1);
    }
}