#include "mbed.h"
#include <math.h>

#define PWM_PERIOD 20

DigitalOut status_led(LED1);

#define N_COLORS 5

typedef enum {red, green, blue, yellow, white} Color;

//#define ORNAMENT_TREE
//#define ORNAMENT_SNOWMAN
#define ORNAMENT_MENORAH

#ifdef ORNAMENT_TREE

#define N_STATUS_BLINK 1

#define N_LEDS 18

DigitalOut leds[N_LEDS] = {D1, A4, D4, A0, A6, A2, D8, D0, A3, D5, D10, D6, A5, D9, D3, D2, D7, A1};

Color colors[N_LEDS] = {
  red, green, blue, yellow, red, green,
  yellow, red, green, blue, yellow,
  green, blue, yellow, red,
  red, green,
  white
};

// Using hardware PWM channels at this scale didn't seem to work
//#define N_PWM 15
//PwmOut pwm_leds[N_PWM] = {D1, D4, A6, A2, D0, A3, D5, D10, D6, A5, D9, D3, D2, D7, A1};

#endif // ORNAMENT_TREE

#ifdef ORNAMENT_SNOWMAN

#define N_STATUS_BLINK 2

#define N_LEDS 15

DigitalOut leds[N_LEDS] = {A4, D6, A3, D7, A6, D3, D2, D0, D1, A5, D5, D4, D8, A2, A1};

Color colors[N_LEDS] = {
  green, green, green, green,
  red, red, red, red, red,
  blue, blue, blue,
  yellow, yellow, yellow
};

#endif // ORNAMENT_SNOWMAN

#ifdef ORNAMENT_MENORAH

#define N_STATUS_BLINK 3

#define N_LEDS 19

DigitalOut leds[N_LEDS] = {D8, D3, D11, A4, D10, A6, A0, D0, D9, D5, A2, A5, D7, D1, A3, D2, D6, D4, A1};

Color colors[N_LEDS] = {
  yellow, blue,
  yellow, green, yellow, blue, yellow, red, yellow, green,
  yellow, green, yellow, red, yellow, blue, yellow, green,
  white
};

#endif // ORNAMENT_MENORAH

float phase[N_COLORS] = {0.0, 0.5, 1.0, 1.5, 2.0};

float fade(float t, float f, float phase, float A) {
  return A * (sin(f * (t + phase)) / 2.0 + 0.5);
}

float chase(float t, float f, int phase, int period, float A) {
  int t_i = (int)(t * f) + phase;
  if ((t_i % period) == 0) {
    return 0.0;
  } else {
    return A;
  }
}

float randf() {
  return ((float)rand()) / RAND_MAX;
}

float update(int i, float t) {
  float pwm = 1.0;

#ifdef ORNAMENT_TREE
  pwm = fade(t, 2.0, phase[colors[i]], 0.6);
#endif // ORNAMENT_TREE

#ifdef ORNAMENT_SNOWMAN
  if (colors[i] == yellow) {
    pwm = fade(t, 2.0, 0.0, 1.0);
  } else {
    pwm = chase(t, 2.0, -i, 9, 0.8);
  }
#endif // ORNAMENT_SNOWMAN

#ifdef ORNAMENT_MENORAH

  if (colors[i] == white) {
    pwm = fade(t, 3.14, 0.0, 1.0);
  } else {
    int candle = (int)(t/2.0) % 10;
    if ((i/2) > candle) {
      pwm = 0.0;
    } else {
      if (colors[i] == yellow) {
        pwm = randf();
        if (pwm < 0.06) {
          pwm = 0.06;
        }
      } else { 
        pwm = 1.0;
      }
    }
  }
  /*if (colors[i] == yellow) {
    if (i/2 > candle) {
      pwm = 0.0;
    } else if (randf() > 0.9) {
      pwm = randf();
      if (pwm < 0.06) {
        pwm = 0.06;
      }
    } else {
      pwm = -1.0;
    }
  } else if(i >= candle) {
    if (i/2 < candle) {
      pwm = 0.0;
    } else {
      pwm = 1.0;
    }
  }*/
#endif // ORNAMENT_MENORAH

  return (int)(pwm * PWM_PERIOD);
}

int pwms[N_LEDS];

Timer system_timer;

int main() {
  int led_count = 0;
  int period_count = 0;
  int timer_mod = 0;
  float pwm_update;

  system_timer.start();

  for (int i = 0; i < N_LEDS; i++ ) {
    pwms[i] = 0;
  }

  while(1) {
    period_count = PWM_PERIOD;

    for (period_count = 0; period_count < PWM_PERIOD; period_count++) {
      for (int i = 0; i < N_LEDS; i++) {
        leds[i] = period_count < pwms[i] ? 1 : 0 ;
      }
    }
    
    pwm_update = update(led_count, system_timer.read_ms() / 1000.0);
    if (pwm_update >= 0.0) {
      pwms[led_count] = pwm_update;
    }

    if (++led_count == N_LEDS) {
      led_count = 0;
    }
    
    timer_mod = system_timer.read_ms() % 2000;

    if ((timer_mod < (300 * N_STATUS_BLINK)) && ((timer_mod % 300) < 50)) {
      status_led = 1;
    } else {
      status_led = 0;
    }
  }
}