#ifndef SCORE_H
#define SCORE_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
/**Score Class
* @brief Counts the score and displays the final score menu when collision
* occurs
* @author Abrar Arif
* @date May, 2019
*/

class Score {
 public:
  /** Constructor */
  Score();
  /** Destructor */
  ~Score();
  /** increments the score
*/
  void score_inc();

  /** Get the score
*@return the current score
*/
  int score_value();
  /** Restarts the score when user wants to play again
*/
  void score_restart();
  /** Displays the score menu along with score
  * @param lcd
*/
  void score_display_menu(N5110 &lcd);

 private:
  int _s;
  int high_score;
};
#endif