#include "Score.h"

Score::Score() {
  // sets the starting value of score
  _s = 0;
  high_score = 0;
}

Score::~Score() {}

void Score::score_inc() {
  // This fuction increments the score
  _s = _s + 1;
};

int Score::score_value() {
  // This fuction return the value of score so can be diplayed on the screen
  return _s;
};
void Score::score_restart() {
  // This function restarts the value of score when game is started again
  _s = 0;
}

void Score::score_display_menu(N5110 &lcd) {
  lcd.clear();
  char A[20];
  int score = _s;
  if (score >=
      high_score) {  // system to set high score of the game which is achieved.
    high_score = score;
  }
  char C[20];
  sprintf(A, "Score=%2d", score);  // this statements futher are basically the
                                   // display when the game is ended and it is
                                   // displays your score and method to play
                                   // again
  lcd.printString(A, 6, 0);
  sprintf(C, "H.Score=%2d", high_score);
  lcd.printString(C, 6, 1);
  lcd.printString("Press Start", 6, 3);
  lcd.printString("To", 30, 4);
  lcd.printString("Play Again", 6, 5);
  lcd.drawRect(0, 0, 5, 48, FILL_BLACK);
  lcd.drawRect(79, 0, 5, 48, FILL_BLACK);
  lcd.drawRect(10, 19, 5, 5, FILL_BLACK);
  lcd.drawRect(20, 19, 5, 5, FILL_BLACK);
  lcd.drawRect(30, 19, 5, 5, FILL_BLACK);
  lcd.drawRect(40, 19, 5, 5, FILL_BLACK);
  lcd.drawRect(50, 19, 5, 5, FILL_BLACK);
  lcd.drawRect(60, 19, 5, 5, FILL_BLACK);
  lcd.drawRect(70, 19, 5, 5, FILL_BLACK);

  lcd.refresh();
  wait(0.05);
};
