#ifndef ENTRANCE_H
#define ENTRANCE_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"

/** Entrance Class
* @brief Displays the entrance and istructions for the game
* @author Abrar Arif
* @date May, 2019
*/

class Entrance {
 public:
  /** Constructor */
  Entrance();
  /** Destructor */
  ~Entrance();
  /** Display credits of the game
  * @param lcd
*/
  void welcome(N5110 &lcd);
  /** displays leds for the user to be more appealing for few seconds
   * @param Gamepad
*/
  void led(Gamepad &pad);
  /** Displays instruction on how to play the game
  * @param lcd
*/
  void instructions(N5110 &lcd);
  /** Display an appealing start menu
*/
  void pictures(N5110 &lcd);
  /** Will not proceed to the game until start is pressed by the user
  * @param Gamepad
*/
  void press_start(Gamepad &pad);

 private:
};
#endif