#include "Entrance.h" 

Entrance::Entrance() {}
Entrance::~Entrance() {}
void Entrance::welcome(N5110 &lcd) {
  // Displays the credits of the game on the screen at the beginning

  lcd.printString("DODGING SQUARE!  ", 0, 0);
  lcd.printString("  Created By  ", 0, 2);
  lcd.printString("  Abrar Arif  ", 0, 3);
  lcd.printString("   el18a3a  ", 0, 4);
  lcd.refresh();
}

void Entrance::led(Gamepad &pad) {
  // This fuction turns on the led and makes it wait for 3 seconds until it goes
  // to next fuction and the lcd is cleared.

  pad.leds_on();
  wait(3);
}

void Entrance::pictures(N5110 &lcd) {
  // This fuction displays the main entrance display of the game.
  lcd.clear();
  lcd.drawRect(1, 1, 48, 45, FILL_TRANSPARENT);
  lcd.drawRect(2, 30, 5, 5, FILL_BLACK);
  lcd.drawRect(43, 30, 5, 5, FILL_BLACK);
  lcd.drawRect(2, 40, 5, 5, FILL_BLACK);
  lcd.drawRect(43, 40, 5, 5, FILL_BLACK);
  lcd.drawRect(18, 28, 15, 15, FILL_TRANSPARENT);

  lcd.printString("DODGING", 4, 1);
  lcd.printString("SQUARE!", 4, 2);
  lcd.printString("PRESS", 52, 4);
  lcd.printString("START", 52, 5);
  lcd.refresh();
}
void Entrance::press_start(Gamepad &pad) {
  // this function wait flashing LEDs until start button is pressed
  while (pad.check_event(Gamepad::START_PRESSED) == false) {
    pad.leds_on();
    wait(0.1);
    pad.leds_off();
    wait(0.1);
    // wait(1.0/24.0);
  }
}

void Entrance::instructions(N5110 &lcd) {
  // This function displays the instrcutions how to play the game on screen and
  // waits forr the it is set for
  lcd.clear();
  lcd.printString("Squares fire", 0, 0);
  lcd.printString("from random", 0, 1);
  lcd.printString("positions have", 0, 2);
  lcd.printString("to dodge them", 0, 3);
  lcd.printString("by Joystick &", 0, 4);
  lcd.printString("button A & Y", 0, 5);
  lcd.refresh();
  wait(5);
}