/* mbed Microcontroller Library
 * Copyright (c) 2018 ARM Limited
 * SPDX-License-Identifier: Apache-2.0
 */

#include "mbed.h"
#include "Adafruit_BNO055.h"

DigitalOut led1(LED1);
I2C i2c(p9, p10); // SDA, SCL
Adafruit_BNO055 bno(-1, 0x28, &i2c);
Serial pc(USBTX, USBRX); // TX, RX

/**************************************************************************/
/*
    Display sensor calibration status
*/
/**************************************************************************/
void displayCalStatus(void)
{
  /* Get the four calibration values (0..3) */
  /* Any sensor data reporting 0 should be ignored, */
  /* 3 means 'fully calibrated" */
  uint8_t system, gyro, accel, mag;
  system = gyro = accel = mag = 0;
  bno.getCalibration(&system, &gyro, &accel, &mag);
 
  /* Display the individual values */
  pc.printf("Calibration: S:%1d G:%1d A:%1d M:%1d\r\n", system, gyro, accel, mag);
}

// main() runs in its own thread in the OS
int main()
{
    pc.baud(115200);
    pc.printf("Initializing...\r\n");

    /* Initialise the sensor */
    if(!bno.begin()) {
        /* There was a problem detecting the BNO055 ... check your connections */
        pc.printf("Ooops, no BNO055 detected ... Check your wiring or I2C ADDR!\r\n");
        while(1);
    }

    bno.setExtCrystalUse(true);

    while (true) {
        /* Get a new sensor event */
        sensors_event_t event;
        bno.getEvent(&event);

        /* Display the floating point data */
        pc.printf("X: %4f   Y: %4f  Z: %4f\r\n",
                  event.orientation.x,
                  event.orientation.y,
                  event.orientation.z);
                  
        displayCalStatus();

        // Blink LED and wait 0.5 seconds
        led1 = !led1;
        wait_ms(100);
    }
}
