#include <stdlib.h>
#include <stdio.h>
#include "doublely_linked_list.h"

DLinkedList* create_dlinkedlist(void)
{

//    printf("create_dlinkedlist\n");

    DLinkedList* newList = (DLinkedList*) malloc(sizeof(DLinkedList));

    newList->size = 0;
    newList->head = NULL;
    newList->current = NULL;
    newList->tail = NULL;

    return newList;

}

LLNode* create_llnode(void* data)
{

//    printf("create_llnode\n");

    LLNode* newNode = (LLNode*) malloc(sizeof(LLNode));

    newNode->previous = NULL;
    newNode->next = NULL;
    newNode->data = data;

    return newNode;

}


void insertHead(DLinkedList* dLinkedList, void* data)
{

//    printf("insertHead\n");

    LLNode* newNode = create_llnode(data);

    if (dLinkedList->head == NULL) {

        dLinkedList->size++;
        dLinkedList->head = newNode;
        dLinkedList->tail = newNode;

    } else {

        dLinkedList->size++;
        newNode->next = dLinkedList->head;
        (dLinkedList->head)->previous = newNode;
        dLinkedList->head = newNode;

    }

}


void insertTail(DLinkedList* dLinkedList, void* data)
{

//    printf("insertTail\n");

    LLNode* newNode = create_llnode(data);

    if (dLinkedList->tail == NULL) {

        dLinkedList->size++;
        dLinkedList->tail = newNode;
        dLinkedList->head = newNode;

    } else {

        dLinkedList->size++;
        newNode->previous = dLinkedList->tail;
        (dLinkedList->tail)->next = newNode;
        dLinkedList->tail = newNode;

    }

}

int insertAfter(DLinkedList* dLinkedList, void* newData)
{

//    printf("insertAfter\n");

    if (dLinkedList->current == NULL) {
        return 0;
    }

    LLNode* newNode = create_llnode(newData);

    dLinkedList->size++;
    newNode->next = (dLinkedList->current)->next;
    newNode->previous = dLinkedList->current;
    if (newNode->next == NULL) {
        dLinkedList->tail = newNode;
    } else {
        (newNode->next)->previous = newNode;
    }
    (newNode->previous)->next = newNode;

    return 1;

}

int insertBefore(DLinkedList* dLinkedList, void* newData)
{

//    printf("insertBefore\n");

    if (dLinkedList->current == NULL) {
        return 0;
    }

    LLNode* newNode = create_llnode(newData);

    dLinkedList->size++;
    newNode->next = dLinkedList->current;
    newNode->previous = (dLinkedList->current)->previous;
    (newNode->next)->previous = newNode;
    if (newNode->previous == NULL) {
        dLinkedList->head = newNode;
    } else {
        (newNode->previous)->next = newNode;
    }

    return 1;

}


void* deleteBackward(DLinkedList* dLinkedList)
{

//    printf("deleteBackward\n");

    if (dLinkedList->current == NULL) {
        return NULL;
    }

    dLinkedList->size--;

    free((dLinkedList->current)->data);

    if ((dLinkedList->current)->previous == NULL) {
        dLinkedList->head = (dLinkedList->current)->next;
    } else {
        ((dLinkedList->current)->previous)->next = (dLinkedList->current)->next;
    }

    if ((dLinkedList->current)->next == NULL) {
        dLinkedList->tail = (dLinkedList->current)->previous;
    } else {
        ((dLinkedList->current)->next)->previous = (dLinkedList->current)->previous;
    }

    LLNode* newCurrent = (dLinkedList->current)->previous;

    free(dLinkedList->current);
    dLinkedList->current = newCurrent;

    if (dLinkedList->current == NULL) {
        return NULL;
    }

    return (dLinkedList->current)->data;

}



void* deleteForward(DLinkedList* dLinkedList)
{

//    printf("deleteForward\n");

    if (dLinkedList->current == NULL) {
        return NULL;
    }

    dLinkedList->size--;

    free((dLinkedList->current)->data);

    if ((dLinkedList->current)->previous == NULL) {
        dLinkedList->head = (dLinkedList->current)->next;
    } else {
        ((dLinkedList->current)->previous)->next = (dLinkedList->current)->next;
    }

    if ((dLinkedList->current)->next == NULL) {
        dLinkedList->tail = (dLinkedList->current)->previous;
    } else {
        ((dLinkedList->current)->next)->previous = (dLinkedList->current)->previous;
    }

    LLNode* newCurrent = (dLinkedList->current)->next;

    free(dLinkedList->current);
    dLinkedList->current = newCurrent;

    if (dLinkedList->current == NULL) {
        return NULL;
    }

    return (dLinkedList->current)->data;

}


void* removeBackward(DLinkedList* dLinkedList)
{

//    printf("removeBackward\n");

    if (dLinkedList->current == NULL) {
        return NULL;
    }

    dLinkedList->size--;

    if ((dLinkedList->current)->previous == NULL) {
        dLinkedList->head = (dLinkedList->current)->next;
    } else {
        ((dLinkedList->current)->previous)->next = (dLinkedList->current)->next;
    }

    if ((dLinkedList->current)->next == NULL) {
        dLinkedList->tail = (dLinkedList->current)->previous;
    } else {
        ((dLinkedList->current)->next)->previous = (dLinkedList->current)->previous;
    }

    void* oldData = (dLinkedList->current)->data;

    LLNode* newCurrent = (dLinkedList->current)->previous;

    free(dLinkedList->current);
    dLinkedList->current = newCurrent;

    return oldData;

}

void* removeForward(DLinkedList* dLinkedList)
{

//    printf("removeForward\n");

    if (dLinkedList->current == NULL) {
        return NULL;
    }

    dLinkedList->size--;

    if ((dLinkedList->current)->previous == NULL) {
        dLinkedList->head = (dLinkedList->current)->next;
    } else {
        ((dLinkedList->current)->previous)->next = (dLinkedList->current)->next;
    }

    if ((dLinkedList->current)->next == NULL) {
        dLinkedList->tail = (dLinkedList->current)->previous;
    } else {
        ((dLinkedList->current)->next)->previous = (dLinkedList->current)->previous;
    }

    void* oldData = (dLinkedList->current)->data;

    LLNode* newCurrent = (dLinkedList->current)->next;

    free(dLinkedList->current);
    dLinkedList->current = newCurrent;

    return oldData;

}


void destroyList(DLinkedList* dLinkedList)
{

//    printf("destroyList\n");

    if (dLinkedList->head != NULL) {
        getHead(dLinkedList);
        while(deleteForward(dLinkedList)) {};
    }

    free(dLinkedList);

}


void* getHead(DLinkedList* dLinkedList)
{

//    printf("getHead\n");

    dLinkedList->current = dLinkedList->head;

    if (dLinkedList->head == NULL) {
        return NULL;
    }

    return (dLinkedList->head)->data;

}



void* getTail(DLinkedList* dLinkedList)
{

//    printf("getTail\n");

    dLinkedList->current = dLinkedList->tail;

    if (dLinkedList->tail == NULL) {
        return NULL;
    }

    return (dLinkedList->tail)->data;

}



void* getCurrent(DLinkedList* dLinkedList)
{

//    printf("getCurrent\n");

    if (dLinkedList->current == NULL) {
        return NULL;
    }

    return (dLinkedList->current)->data;

}



void* getNext(DLinkedList* dLinkedList)
{

//    printf("getNext\n");

    if (dLinkedList->current == NULL) {
        return NULL;
    }

    dLinkedList->current = (dLinkedList->current)->next;

    if (dLinkedList->current == NULL) {
        return NULL;
    }

    return (dLinkedList->current)->data;

}



void* getPrevious(DLinkedList* dLinkedList)
{

//    printf("getPrevious\n");

    if (dLinkedList->current == NULL) {
        return NULL;
    }

    dLinkedList->current = (dLinkedList->current)->previous;

    if (dLinkedList->current == NULL) {
        return NULL;
    }

    return (dLinkedList->current)->data;

}


int getSize(DLinkedList* dLinkedList)
{

//    printf("getSize\n");

    return dLinkedList->size;

}