#ifndef APA102_H_
#define APA102_H_

#include "mbed.h"

struct CRGB {
    
    union {
        struct {
            union {
                uint8_t r;
                uint8_t red;
            };
            union {
                uint8_t g;
                uint8_t green;
            };
            union {
                uint8_t b;
                uint8_t blue;
            };
        };
        uint8_t raw[3];
    };
    
    inline CRGB() __attribute__((always_inline)) {}
    
    inline CRGB( uint8_t ir, uint8_t ig, uint8_t ib)  __attribute__((always_inline))
        : r(ir), g(ig), b(ib) {}
    
    inline CRGB( uint32_t colorcode)  __attribute__((always_inline))
        : r((colorcode >> 16) & 0xFF), g((colorcode >> 8) & 0xFF), b((colorcode >> 0) & 0xFF) {}
    
    typedef enum {
        Black=0x000000,
    } HTMLColorCode;
    
};

inline __attribute__((always_inline)) bool operator== (const CRGB& lhs, const CRGB& rhs) {
    return (lhs.r == rhs.r) && (lhs.g == rhs.g) && (lhs.b == rhs.b);
}

__attribute__((always_inline))
inline CRGB operator*( const CRGB& p1, double d) {
    return CRGB(p1.r * d, p1.g * d, p1.b * d);
}

void fill_solid( struct CRGB * leds, int numToFill, const struct CRGB& color);

void APA102_write(mbed::SPI& mSPI, struct CRGB * leds, int numToFill);

#endif