#include "mbed.h"
#include "APA102.h"

void fill_solid( struct CRGB * leds, int numToFill, const struct CRGB& color) {
    for(int i = 0; i < numToFill; i++) {
        leds[i] = color;
    }
}

void APA102_write(mbed::SPI& mSPI, struct CRGB * leds, int numToFill) {
    
    mSPI.write(0);
    mSPI.write(0);
    mSPI.write(0);
    mSPI.write(0);
    
    for (int i = 0; i < numToFill; ++i) {
        mSPI.write(0xE0 | 31);
        mSPI.write(leds[i].b);
        mSPI.write(leds[i].g);
        mSPI.write(leds[i].r);
    }
    
    int nDWords = numToFill / 32;
    do {
        mSPI.write(0xFF);
        mSPI.write(0x00);
        mSPI.write(0x00);
        mSPI.write(0x00);
    } while(nDWords--); 
    
}
