#include "mbed.h"
#include "USBHostMSD.h"
#include "wave_player.h"
#include "uLCD_4DGL.h"

AnalogOut DACout(p18);
PwmOut PWMout(p26);

wave_player waver(&DACout,&PWMout);

PwmOut Rgb(p23);
PwmOut rGb(p24);
PwmOut rgB(p25);

int dim = 0;

uLCD_4DGL uLCD(p9, p10, p11); // serial tx, serial rx, reset pin;
Mutex uLCD_mutex;

Serial blue(p28, p27);

BusOut myled(LED1,LED2,LED3,LED4);

void thread1(void const *args)
{
    float x = 0.0;
    while(1) {
        //get a new random number for PWM
        x = rand() / float(RAND_MAX);
        //add some exponential brightness scaling
        //for more of a fast flash effect
        x = x*x*x;
        Rgb = x;
        rGb = x * dim;
        rgB = x * dim;
        //fast update rate for welding flashes
        Thread::wait(20);
        //add a random pause between welds
        if (rand() / float(RAND_MAX) > 0.97) {
            Rgb = 0;
            rGb = 0;
            rgB = 0;
            Thread::wait(4000.0 * rand() / float(RAND_MAX));
        }
    }

}

void thread2(void const *args)
{
    while(1) {
        uLCD_mutex.lock();
        uLCD.locate(1,2);
        uLCD.printf("Lightning!!!");
        uLCD_mutex.unlock();

        Thread::wait(20);

        uLCD_mutex.lock();
        uLCD.locate(1,2);
        uLCD.printf("            ");
        uLCD_mutex.unlock();

        if (rand() / float(RAND_MAX) > 0.97) {
            Thread::wait(4000.0 * rand() / float(RAND_MAX));
        }
    }
}

void thread3(void const *args)
{
    while (1) {
        uLCD_mutex.lock();
        uLCD.locate(1,5);
        uLCD.printf("Thunder!!!");
        uLCD_mutex.unlock();

        Thread::wait(20);

        uLCD_mutex.lock();
        uLCD.locate(1,5);
        uLCD.printf("          ");
        uLCD_mutex.unlock();

        if (rand() / float(RAND_MAX) > 0.97) {
            Thread::wait(4000.0 * rand() / float(RAND_MAX));
        }
    }
}

void thread4(void const *args)
{
    char bnum=0;
    char bhit=0;
    while(1) {
        while (!blue.readable()) {
            Thread::wait(20);
        }
        uLCD_mutex.lock();
        if (blue.getc()=='!') {
            if (blue.getc()=='B') { //button data packet
                bnum = blue.getc(); //button number
                bhit = blue.getc(); //1=hit, 0=release
                if (blue.getc()==char(~('!' + 'B' + bnum + bhit))) { //checksum OK?
                    myled = bnum - '0'; //current button number will appear on LEDs
                    switch (bnum) {
                        case '1': //number button 1
                            dim = (bhit == '0');
                            break;
                        case '2': //number button 2
                            if (bhit=='1') {
                                //add hit code here
                            } else {
                                //add release code here
                            }
                            break;
                        case '3': //number button 3
                            if (bhit=='1') {
                                //add hit code here
                            } else {
                                //add release code here
                            }
                            break;
                        case '4': //number button 4
                            if (bhit=='1') {
                                //add hit code here
                            } else {
                                //add release code here
                            }
                            break;
                        default:
                            break;
                    }
                }
            }
        }
        uLCD_mutex.unlock();
    }
}

int main()
{
    Thread t1(thread1);
    Thread t2(thread2);
    Thread t3(thread3);
    Thread t4(thread4);

    USBHostMSD msd("usb");
    FILE *wave_file;
    //setup PWM hardware for a Class D style audio output
    PWMout.period(1.0/400000.0);
    printf("\n\n\nHello, wave world!\n");
    // wait until connected to a USB device
    while(!msd.connect()) {
        Thread::wait(500);
    }
    while (1) {
        //open wav file and play it
        wave_file=fopen("/usb/storm-thunder.wav","r");
        waver.play(wave_file);
        fclose(wave_file);
        Thread::wait(4000.0 * rand() / float(RAND_MAX));
    }
}