#include "mbed.h"
#include "EthernetInterface.h"

Serial pc(USBTX, USBRX);

int main()
{
    pc.printf("Hi! ");

    char mac[6];
    mbed_mac_address(mac);
    pc.printf("mbed MAC address is %02x:%02x:%02x:%02x:%02x:%02x\n\r", mac[0], mac[1], mac[2], mac[3], mac[4], mac[5]);
    
    pc.printf("1");
    EthernetInterface eth;
    pc.printf("2");
    eth.init(); //Use DHCP
    pc.printf("3");
    eth.connect();
    pc.printf("IP Address is %s\n", eth.getIPAddress());

    TCPSocketConnection sock;
    sock.connect("mbed.org", 80);

    char http_cmd[] = "GET /media/uploads/mbed_official/hello.txt HTTP/1.0\n\n";
    sock.send_all(http_cmd, sizeof(http_cmd)-1);

    char buffer[300];
    int ret;
    while (true) {
        ret = sock.receive(buffer, sizeof(buffer)-1);
        if (ret <= 0)
            break;
        buffer[ret] = '\0';
        pc.printf("Received %d chars from server:\n%s\n", ret, buffer);
    }

    sock.close();

    eth.disconnect();

    while(1) {}
}
