#include "mbed.h"
#include "LSM9DS1.h"
#include "uLCD_4DGL.h"

#define PI 3.14159

// Earth's magnetic field varies by location. Add or subtract
// a declination to get a more accurate heading. Calculate
// your's here:
// http://www.ngdc.noaa.gov/geomag-web/#declination
#define DECLINATION -4.94 // Declination (degrees) in Atlanta,GA.

Serial pc(USBTX, USBRX);
uLCD_4DGL uLCD(p9,p10,p11); // serial tx, serial rx, reset pin;

int main()
{
    uLCD.cls();
    uLCD.printf("Baud rate: 3000000");
    uLCD.baudrate(3000000);

    uLCD.printf("Calibrating IMU...\n");
    LSM9DS1 IMU(p28, p27, 0xD6, 0x3C);
    bool success = IMU.begin();
    if (!success) {
        uLCD.printf("Failed to communicate with LSM9DS1.\n");
    }
    IMU.calibrate(1);

    wait(0.5);
    uLCD.cls();
    while(1) {
        while(!IMU.accelAvailable());
        IMU.readAccel();
        uLCD.circle(64, 64, 48, GREEN);
        uLCD.circle(64, 64, 24, GREEN);
        uLCD.filled_circle(64 + IMU.calcAccel(IMU.ax) * -40, 64 + IMU.calcAccel(IMU.ay) * -40, 16, GREEN);
        wait(0.05);
        uLCD.filled_circle(64 + IMU.calcAccel(IMU.ax) * -40, 64 + IMU.calcAccel(IMU.ay) * -40, 16, BLACK);
    }
}
