#include "mbed.h"
#include "PinDetect.h"

//Class to control an RGB LED using three PWM pins
class RGBLed
{
public:
    RGBLed(PinName redpin, PinName greenpin, PinName bluepin);
    void write(float red,float green, float blue);
private:
    PwmOut _redpin;
    PwmOut _greenpin;
    PwmOut _bluepin;
};

RGBLed::RGBLed (PinName redpin, PinName greenpin, PinName bluepin)
    : _redpin(redpin), _greenpin(greenpin), _bluepin(bluepin)
{
    //50Hz PWM clock default a bit too low, go to 2000Hz (less flicker)
    _redpin.period(0.0005);
}

void RGBLed::write(float red,float green, float blue)
{
    _redpin = red;
    _greenpin = green;
    _bluepin = blue;
}

//Setup RGB led using PWM pins and class
RGBLed myRGBled(p21,p22,p23); //RGB PWM pins

DigitalIn r(p24);
DigitalIn g(p25);
DigitalIn b(p26);

PinDetect pb1(p8);
PinDetect pb2(p7);

// Global pwm variable
float volatile pwm=1.0f;

// Callback routine is interrupt activated by a debounced pb1 hit
void pb1_hit_callback (void)
{
    pwm -= 0.1f;
    if (pwm < 0.0f) {
        pwm = 0.0f;
    }
}

// Callback routine is interrupt activated by a debounced pb2 hit
void pb2_hit_callback (void)
{
    pwm += 0.1f;
    if (pwm > 1.0f) {
        pwm = 1.0f;
    }
}

int main()
{
    r.mode(PullUp);
    g.mode(PullUp);
    b.mode(PullUp);

    // Use internal pullups for pushbutton
    pb1.mode(PullUp);
    pb2.mode(PullUp);
    // Delay for initial pullup to take effect
    wait(.01);
    // Setup Interrupt callback functions for a pb hit
    pb1.attach_deasserted(&pb1_hit_callback);
    pb2.attach_deasserted(&pb2_hit_callback);
    // Start sampling pb inputs using interrupts
    pb1.setSampleFrequency();
    pb2.setSampleFrequency();

    while(1) {
        myRGBled.write(!r*pwm,!g*pwm,!b*pwm);
    }
}
