#include "mbed.h"
#include "PinDetect.h"
// must import Cookbook PinDetct library into project
// URL: http://mbed.org/users/AjK/libraries/PinDetect/lkyxpw

PwmOut myled(p23);

PinDetect pb1(p8);
PinDetect pb2(p7);
// SPST Pushbutton debounced count demo using interrupts and callback
// no external PullUp resistor needed
// Pushbutton from P8 to GND.
// Second Pushbutton from P7 to GND.
// A pb hit generates an interrupt and activates the callback function
// after the switch is debounced

// Global pwm variable
float volatile pwm=1.0f;

// Callback routine is interrupt activated by a debounced pb1 hit
void pb1_hit_callback (void)
{
    pwm -= 0.1f;
    if (pwm < 0.0f) {
        pwm = 0.0f;
    }
}

// Callback routine is interrupt activated by a debounced pb2 hit
void pb2_hit_callback (void)
{
    pwm += 0.1f;
    if (pwm > 1.0f) {
        pwm = 1.0f;
    }
}

int main()
{

    // Use internal pullups for pushbutton
    pb1.mode(PullUp);
    pb2.mode(PullUp);
    // Delay for initial pullup to take effect
    wait(.01);
    // Setup Interrupt callback functions for a pb hit
    pb1.attach_deasserted(&pb1_hit_callback);
    pb2.attach_deasserted(&pb2_hit_callback);
    // Start sampling pb inputs using interrupts
    pb1.setSampleFrequency();
    pb2.setSampleFrequency();

    while (1) {
        myled = pwm;
    }

}
