//Klasser fra biblioteker
Thread thread;
InterruptIn button(USER_BUTTON);
DigitalOut led(LED1);
AnalogIn temp(A3);
AnalogIn lyd(A1);
AnalogIn LightSensor(A0);
LCD_DISCO_F746NG lcd;
TS_DISCO_F746NG ts;

//Variabler
const int R0 = 100000;
const int B=4275;

bool btnPress = true;

double temperature;
double fahrenheit;

//Variabler Til display & Info fra user input
int Bnr;
int Lnr;
int inp;
//variabler til data iteration
int i;
//antal er sat til 1, for at tage 1 sæt af gangen
int antal = 1;
char cAntal[5];
//lys
float LVal;
//lyd
int lydstyrke;
int cPut;
//til display, unsigned int 8 bit(255 i decimanl)
uint8_t text[30];

//Voids
//Denne funktion bruger parameter overførsel for at håndtere vores indput fra putty/console
void Num(char ln[], int M)
{
    //i2 for at have sin egen itererings variabel, da i, er brugt andre steder til for loops
    int i2 = 0;
    char c;
    //imens i2 variablen er mindre end max værdien og vores input ikke er i begyndelsen af linjen,
    //tilføjes en char til vores array(string)
    while (i2 < M  && (c = getchar()) != '\r')
        //Tilføjer alle chars med optælling
    ln[i2++] = c;
    ln[i2] = '\0';
}
//Parameter overfører bygnings og lokale nummer til display
void DisplayVoid(int B, int L)
{
    lcd.Clear(LCD_COLOR_DARKBLUE);
    lcd.SetBackColor(LCD_COLOR_DARKBLUE);
    lcd.SetTextColor(LCD_COLOR_WHITE);
    sprintf((char*)text, "Bygning: %d", B);
    lcd.DisplayStringAt(0, LINE(1), (uint8_t *)&text, LEFT_MODE);
    sprintf((char*)text, "Lokale: %d", L);
    lcd.DisplayStringAt(0, LINE(2), (uint8_t *)&text, LEFT_MODE);
}
//Denne void bruges til Tråd
void InputThread()
{
    while (1) {
        wait(0.5);
        //getchar() skal defineres til int for at kunne parses. Chars i c programmering parses som int
        inp = getchar();
        //input skal være lig den definerede værdi og vil ikke returnere noget hvis det er tomt/null
        if (inp == '1' && inp != (int)"\0")
            printf("Temperatur i hex: %x\n", (int)temp.read_u16());
        else if (inp == '2' && inp != (int)"\0")
            printf("Lyd: %d\n", lydstyrke);
        else if (inp == '3' && inp != (int)"\0")
            printf("Lys: %f\n", LVal);
        //returnerer intet, hvis ovenstående statements ikke bliver mødt
        else
            printf("");
    }
}

void TempVoid()
{
//Defineres ud i et, uden del-variabler(undtagen konstanter), så værdien bliver dynamisk
    temperature=1.0/(log(R0*(65535.0/((double)temp.read_u16())-1.0)/R0)/B+1/298.15)-273.15;
    fahrenheit = temperature * 1.8 + 32;
    if(btnPress == true) {
        sprintf((char*)text, "Temperatur: %f", temperature);
        lcd.DisplayStringAt(0, LINE(5), (uint8_t *)&text, CENTER_MODE);
    } else if(btnPress == false) {
        sprintf((char*)text, "Fahrenheit: %f",    fahrenheit );
        lcd.DisplayStringAt(0, LINE(5), (uint8_t *)&text, CENTER_MODE);
    }
}

void LydVoid()
{
    lydstyrke = (int)lyd.read_u16();
    if(lydstyrke != 0 && lydstyrke > 25000) {
        sprintf((char*)text, "Sound is too high");
        lcd.DisplayStringAt(0, LINE(6), (uint8_t *)&text, CENTER_MODE);
        wait(2.00);
    } else if(lydstyrke != 0 && lydstyrke <25000) {
        sprintf((char*)text, "Sound level is ok");
        lcd.DisplayStringAt(0, LINE(6), (uint8_t *)&text, CENTER_MODE);
        wait(0.25);
    }
}

void LysVoid()
{
    LVal  = (float)(1023-LightSensor.read())*10/LightSensor.read();
    if(LVal <= 55000) {
        sprintf((char*)text, "It's bright now  ");
        lcd.DisplayStringAt(0, LINE(0), (uint8_t *)&text, LEFT_MODE);
    } else if(LVal > 55000) {
        sprintf((char*)text, "It's getting dark ");
        lcd.DisplayStringAt(0, LINE(0), (uint8_t *)&text, LEFT_MODE);
    }
}
//Til user button
void pressed()
{
    btnPress = false;
}
void pressed2()
{
    btnPress = true;
}
