/*!
 * Shinyei.cpp
 *
 * Read the particle concentration using a Shinyei PPD42NJ sensor
 *
 * Copyright (c) 2017 -  Alexandre Bouillot github.com/abouillot
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documnetation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to  whom the Software is
 * furished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS OR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
 
#include "mbed.h"
#include "PwmReader.h"

class Shinyei
{
public:
    Shinyei(PinName pin) : _pwm(pin), _dataReady(false) {
    };
    void startSampling(int duration = 30);
    void startSampling(Callback< void()>, int duration = 30);
    void stopSampling();
    bool dataReady() {
        return _dataReady;
    };
    float concentration() {
        if (_dataReady)
            return _concentration;
        else
            return -1;
    };
private:
    void samplingComplete();
    void init();
    PwmReader _pwm;
    bool _dataReady;
    Timeout _samplingTimer;
    float _concentration;
    Callback<void()> _callback;
    bool _callbackSet;
};