/*!
 * Shinyei.cpp
 *
 * Read the particle concentration using a Shinyei PPD42NJ sensor
 *
 * Copyright (c) 2017 -  Alexandre Bouillot github.com/abouillot
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documnetation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to  whom the Software is
 * furished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS OR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
 
#include "Shinyei.h"

void Shinyei::startSampling(int duration)
{
    _samplingTimer.attach(callback(this, &Shinyei::samplingComplete), (float)duration);
    _dataReady = false;
    _callbackSet = false;
    _pwm.start();
}

void Shinyei::startSampling(Callback<void()> function, int duration)
{
    _samplingTimer.attach(callback(this, &Shinyei::samplingComplete), (float)duration);
    _dataReady = false;
    _callbackSet = true;
    _callback = function;
    _pwm.start();
}


void Shinyei::stopSampling()
{
    _pwm.stop();
//    _callbackSet = false;
// Need to cancel the timer
//    _samplingTimer.attach(callback(this, &samplingComplete), (float)duration);
    _dataReady = false;
    _pwm.start();
}

void Shinyei::samplingComplete()
{
    _pwm.stop();
    float ratio = _pwm.occupacyLow();
    _concentration = 1.1*pow(ratio,3)-3.8*pow(ratio,2)+520*ratio+0.62; // using spec sheet curve
    _dataReady = true;
    if (_callbackSet)
        _callback();
}