/*!
 * Sds021.cpp
 *
 * Control the inovafitness particles sensor SDS021
 *
 * Copyright (c) 2017 -  Alexandre Bouillot github.com/abouillot
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documnetation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to  whom the Software is
 * furished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS OR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
 
#ifndef __SDS021_H__
#define __SDS021_H__

#include "mbed.h"
#include "BufferedSerial.h"


class SDS021
{
public:
/* public structures and constants */
    typedef struct version {
        char year;
        char month;
        char day;
    } version_t;
    
public:

    SDS021(PinName tx, PinName rx) : _sds021(tx, rx), _PM2_5(0), _PM10(0), _mode(false), _state(true), _interval(0),  _id(0xffff) {
        _firmware.year = 0;
    }
    bool update();
    int getId() {
        return _id;
    };
    void setId(int new_id);
    bool getPassiveMode() {
        return _mode;
    };
    void setPassiveMode(bool passive);
    void readData();
    uint8_t getInterval() {
        return _interval;
    };
    void setInterval(uint8_t minutes);
    bool getAwake() {
        return _state;
    };
    void setAwake(bool working);
    version_t getVersion();

    float PM2_5() {
        return _PM2_5;
    };
    float PM10() {
        return _PM10;
    };
    bool mode() {
        return _mode;
    };
    bool state() {
        return _state;
    };
    char interval() {
        return _interval;
    };
    version_t firmware() {
        return _firmware;
    };
    int id() {
        return _id;
    };

private:
/* constants and structures types */
    static const int kOutputLength = 19;
    static const int kInputLength = 10;

    static const char head = 0xaa;
    static const char tail = 0xab;

// commands
    enum command_t {
        commandCmd = 0xB4,
        dataCmd = 0xC0,
        replyCmd = 0xC5
    };

// actions
    enum action_t {
        modeAct = 0x2,
        queryAct = 0x4,
        idAct = 0x5,
        stateAct = 0x6,
        versionAct = 0x7,
        intervalAct = 0x8
    };

private:
/* lacal variables */
    char outMessage[kOutputLength];
    char inMessage[kInputLength];

    char* prepareMessage(SDS021::action_t action, bool set = 0, int address = 0xFFFF, int value = 0);
    char calcCheckSum(char* buffer, int start_idx, int stop_idx);
    bool checkSum(char* buffer, int start_idx = 2, int stop_idx = 8);
    void writeMessage(char* buffer);

    BufferedSerial _sds021;
    float _PM2_5;
    float _PM10;
    bool _mode;
    bool _state;
    char _interval;
    version_t _firmware;
    int _id;
};

#endif  // __SDS021_H__
