/*!
 * main.cpp
 *
 * Program to test interaction with inovafitness SDS021 particle Sensor
 *
 * Copyright (c) 2017 -  Alexandre Bouillot github.com/abouillot
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documnetation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to  whom the Software is
 * furished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS OR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
 
#include "mbed.h"
#include "Sds021.h"
DigitalOut myled(LED1);

Serial pc(USBTX, USBRX, 115200);
SDS021 sds(PC_10, PC_11);

void printSdsData()
{
    pc.printf("PM2.5: %f PM10: %f Mode: %d State: %d Interval: %d Id: %04x Version: %02d/%02d/%02d\n", sds.PM2_5(), sds.PM10(), sds.mode(), sds.state(), sds.interval(), sds.id(), sds.firmware().year, sds.firmware().month, sds.firmware().day);
}

void testId()
{
    Timer s;
    int i;
    pc.printf("\n++ set id\n");
    while (!sds.update());
    int origId = sds.getId();
    pc.printf("Original id: 0x%04x", origId);

    pc.printf("Set id to 0xcafe\n");
    sds.setId(0xcafe);

    while (!sds.update());
    printSdsData();

    for (i=0; i<3; i++) {
        while (!sds.update());
        printSdsData();
    }

    pc.printf("Set id to initial value\n");
    sds.setId(origId);

    for (i=0; i<3; i++) {
        while (!sds.update());
        printSdsData();
    }
}
void testMode()
{
    Timer s;
    int i;
    pc.printf("\n++ set mode\n");
//    while (!update());
//    int origMode = getPassiveMode();
    int origMode = false;

    pc.printf("Set mode to passive\n");
    sds.setPassiveMode(true);
    printSdsData();

#if 0
    s.reset();
    s.start();
    while (s.read() < 5) {
        if (sds021.readable()) {
            pc.printf("%02x ", sds021.getc());
        }
    }
    s.stop();
#endif
    pc.printf("\nrequest data update\n");
    sds.readData();
    printSdsData();
    pc.printf("data update completed\n");
#if 0
    s.reset();
    s.start();
    while (s.read() < 5) {
        if (sds021.readable()) {
            pc.printf("%02x ", sds021.getc());
        }
    }
    s.stop();
#endif

    pc.printf("set mode to active\n");
    sds.setPassiveMode(false);
    printSdsData();

#if 0
    s.reset();
    s.start();
    while (s.read() < 10) {
        if (sds021.readable()) {
            pc.printf("%02x ", sds021.getc());
        }
    }
    s.stop();
#endif

    printf("set mode to original value: %d", origMode);
    sds.setPassiveMode(origMode);
    printSdsData();

    for ( i=0; i<3; i++) {
        while (!sds.update());
        printSdsData();
    }
}
void testInterval()
{
    Timer s;
    int i;
    pc.printf("\n++ set mode\n");
    while (!sds.update());
    int origInterval = sds.getInterval();

    pc.printf("Set to 0 seconds\n");
    sds.setInterval(0);
    s.reset();
    s.start();
    while (!sds.update());
    pc.printf("delay: %d ", s.read());
    printSdsData();
    while (!sds.update());
    pc.printf("delay: %d ", s.read());
    printSdsData();
    s.stop();

    pc.printf("Set to 5 minutes\n");
    sds.setInterval(5);
    s.reset();
    s.start();
    while (!sds.update());
    pc.printf("delay: %d ", s.read());
    printSdsData();
    while (!sds.update());
    pc.printf("delay: %d ", s.read());
    printSdsData();
    s.stop();

    pc.printf("Set to 2 minutes\n");
    sds.setInterval(2);
    s.reset();
    s.start();
    while (!sds.update());
    pc.printf("delay: %d", s.read());
    printSdsData();
    while (!sds.update());
    pc.printf("delay: %d", s.read());
    printSdsData();
    s.stop();

    pc.printf("Set beyond 30 minutes (45 minutes) \n");
    sds.setInterval(45);
    sds.readData();
    while (!sds.update());
    printSdsData();

    pc.printf("Set back to initial value\n");
    sds.setInterval(origInterval);
    s.reset();
    s.start();
    while (!sds.update());
    pc.printf("delay: %d", s.read());
    printSdsData();
    while (!sds.update());
    pc.printf("delay: %d", s.read());
    printSdsData();
    s.stop();
}
int main()
{
    Timer s;
    int i;
    pc.printf("\n**************SDS021 TEST***************\n");
    wait(1);

    sds.setPassiveMode(false);
    sds.setInterval(0);

    SDS021::version_t ver = sds.getVersion();
    pc.printf("Version: %02d/%02d/%02d\n", ver.year, ver.month, ver.day);
    sds.setId(0xaa3f);
    

//    sds.setPassiveMode(true);
//setId(0xcafe);

//    readData();



    testId();

    testMode();
    testInterval();

    pc.printf("\n**************SDS021 TEST COMPLETED***************\n");
}
