/*!
 * Test application
 *
 * Read particle concentration using a Shinyei PPD42NJ sensor
 *
 * Copyright (c) 2017 -  Alexandre Bouillot github.com/abouillot
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documnetation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to  whom the Software is
 * furished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS OR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#include "mbed.h"
#include "Shinyei.h"

Serial pc(SERIAL_TX, SERIAL_RX);

DigitalOut myled(LED1);

// define asynch_test to demonstrate the non blocking usage
//#define asynch_test
#define asynch_test

#if defined(asynch_test)
Shinyei shinyei(USER_BUTTON);

void completeSampling()
{
    printf("Concentration: %f\n", shinyei.concentration());
    shinyei.startSampling(completeSampling, 30);
}
#endif

int main()
{
    printf("**************** PwmReader test program ****************\n");

#if defined(asynch_test)
    shinyei.startSampling(completeSampling, 30);

    int i = 1;
    pc.printf("Hello World !\n");
    while(1) {
        wait(1);
        pc.printf(".", i++, shinyei.concentration());
        myled = !myled;
    }
#else
    Shinyei shinyei(USER_BUTTON);
    while (1) {
        shinyei.startSampling(30);

        while (!shinyei.dataReady()) {
            pc.printf(".");
            wait(.5);
        }
        wait(5);
        pc.printf("\n");

        pc.printf("Concentration: %f\n", shinyei.concentration());
    }
#endif
}


