/*!
 * PwmReader.cpp
 *
 * Read signal occupacy on a pin in a non blocking way using timer and interrupt
 *
 * Copyright (c) 2017 -  Alexandre Bouillot github.com/abouillot
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documnetation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to  whom the Software is
 * furished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS OR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#include "PwmReader.h"

/// #define TRACE to enable TRACEs using printf #undef to disable
#undef TRACE


void PwmReader::pressedInt()
{
    long now = _timer.read_us();
    // signal moved from high to low, record the time spent in this state
    _high += _timer.read_us() - _last_toggle;
    // record the new timestamp
    _last_toggle = _timer.read_us();
#ifdef TRACE
    printf("p %ld ", _high);
#endif
//    sleep();
}

void PwmReader::releasedInt()
{
    long now = _timer.read_us();
    // signal moved from down to high, record the time spent in this state
    _down += now - _last_toggle;
    // record the new timestamp
    _last_toggle = now;
#ifdef TRACE
    printf("r %ld", _down);
#endif
//    sleep();
}

void PwmReader::init()
{
    // register the interupt attached with the levels changes
    _pin.fall(callback(this, &PwmReader::pressedInt));
    _pin.rise(callback(this, &PwmReader::releasedInt));
}

void PwmReader::start()
{
    // reset the storing variable
    _high = 0;
    _down = 0;
    _last_toggle = 0;

    // store the inital state
    _start_state = _pin.read();

    // start the timer at 0
    _timer.reset();
    _timer.start();

    // enable the IRQ requests
    _pin.enable_irq();

#ifdef TRACE
    if (_pin.read() != _start_state) {
        printf("toggle ");
    }
    if (_pin.read() == 0) {
        printf("low ");
    }
    if (_pin.read() == 1) {
        printf("high ");
    }
#endif
}

void PwmReader::stop()
{
    // disable the IRQ request, to avoid code call
    _pin.disable_irq();

    // no time has been recorded. The signal stayed at the same level from the start of measurment
    if (_high == 0 && _down == 0)
        // retrieve the duration of the measurment to assign it to the right state
        if (_start_state == 1)
            _high = _timer.read_us();
        else if (_start_state == 0)
            _down = _timer.read_us();

    // stop the running timer
    _timer.stop();
}