#include "mbed.h"
#include "USBHostGamepad.h"
 
DigitalOut led(LED3);

void onGamepadEvent(uint8_t x, uint8_t y, uint8_t z, uint8_t rz, uint16_t buttons) {
    printf("x: %02X, y: %02X, z: %02X, rz: %02X, buttons: %04X\r\n",
           x, y, z, rz, buttons);
}
 
void gamepad_task() {    
    USBHostGamepad gamepad;
    
    while(1) {
        // try to connect a USB Gamepad
        while(!gamepad.connect())
            Thread::wait(500);

        // when connected, attach handler called on Gamepad event
        gamepad.attachEvent(onGamepadEvent);
        
        // wait until the Gamepad is disconnected
        while(gamepad.connected())
            Thread::wait(500);
    }
}
 
int main() {
    Thread gamepadTask(osPriorityNormal, 1024 * 4);
    gamepadTask.start(gamepad_task);

    printf("MBED USB GAMEPAD\n\r");

    while(1) {
        led=!led;
        Thread::wait(500);
    }
}
