/* mbed Microcontroller Library
 * Copyright (c) 2006-2013 ARM Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef __BLE_RELAY_SERVICE_H__
#define __BLE_RELAY_SERVICE_H__

class RelayService
{
public:
    const static uint16_t RELAY_SERVICE_UUID              = 0xA000;
    const static uint16_t RELAY_STATE_CHARACTERISTIC_UUID = 0xA001;

    RelayService(BLEDevice &_ble, bool initialValueForRelayCharacteristic) :
        ble(_ble), relayState(RELAY_STATE_CHARACTERISTIC_UUID, &initialValueForRelayCharacteristic) {
        GattCharacteristic *charTable[] = {&relayState};
        GattService         relayService(RELAY_SERVICE_UUID, charTable, sizeof(charTable) / sizeof(GattCharacteristic *));
        ble.addService(relayService);
    }

    GattAttribute::Handle_t getValueHandle() const {
        return relayState.getValueHandle();

    }

private:
    BLEDevice                         &ble;
    ReadWriteGattCharacteristic<bool>  relayState;
};

#endif /* #ifndef __BLE_RELAY_SERVICE_H__ */