/* mbed Microcontroller Library
 * Copyright (c) 2006-2013 ARM Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef __BLE_PIR_SERVICE_H__
#define __BLE_PIR_SERVICE_H__

class PIRService
{
public:
    const static uint16_t PIR_SERVICE_UUID              = 0xA000;
    const static uint16_t PIR_STATE_CHARACTERISTIC_UUID = 0xA001;

    PIRService(BLEDevice &_ble, bool initialValueForPIRCharacteristic) :
        ble(_ble), pirStateCharacteristic(PIR_STATE_CHARACTERISTIC_UUID, &initialValueForPIRCharacteristic) {
        GattCharacteristic *charTable[] = {&pirStateCharacteristic};
        GattService         pirService(PIR_SERVICE_UUID, charTable, sizeof(charTable) / sizeof(GattCharacteristic *));
        ble.addService(pirService);
    }

    GattAttribute::Handle_t getValueHandle() const {
        return pirStateCharacteristic.getValueHandle();
    }
    
    void UpdateMotionStatus(bool status) {
        ble.updateCharacteristicValue(pirStateCharacteristic.getValueHandle(), (uint8_t *)&status, sizeof(bool));
    }

private:
    BLEDevice                         &ble;
    ReadOnlyGattCharacteristic<bool>  pirStateCharacteristic;
};

#endif /* #ifndef __BLE_PIR_SERVICE_H__ */