/* mbed Microcontroller Library
 * Copyright (c) 2006-2013 ARM Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "mbed.h"
#include "BLEDevice.h"
#include "PIRService.h"

BLEDevice ble;

InterruptIn pir(p4);

bool motion_detected = 0;
int interval = 0;
static const int PUBLISH_TIMESLISE = 10; //once detected, publish for 10 sec, important data so keep broadcasting for 10 sec.


const static char     DEVICE_NAME[] = "PIR";
static const uint16_t uuid16_list[] = {PIRService::PIR_SERVICE_UUID};

//PIRService *pirServicePtr;

void irq_handler(void)
{
    motion_detected = 1;
    interval = PUBLISH_TIMESLISE;
}

void disconnectionCallback(Gap::Handle_t handle, Gap::DisconnectionReason_t reason)
{
    ble.startAdvertising();
}

int main() {

    ble.init();
    ble.onDisconnection(disconnectionCallback);

    ble.accumulateAdvertisingPayload(GapAdvertisingData::BREDR_NOT_SUPPORTED | GapAdvertisingData::LE_GENERAL_DISCOVERABLE);
    ble.accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LIST_16BIT_SERVICE_IDS, (uint8_t *)uuid16_list, sizeof(uuid16_list));
    ble.accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LOCAL_NAME, (uint8_t *)DEVICE_NAME, sizeof(DEVICE_NAME));
    ble.setAdvertisingType(GapAdvertisingParams::ADV_CONNECTABLE_UNDIRECTED);
    ble.setAdvertisingInterval(Gap::MSEC_TO_ADVERTISEMENT_DURATION_UNITS(1000));
    ble.startAdvertising();
    
    PIRService pirService(ble, motion_detected);
    
    pir.rise(&irq_handler);
    
    while(1) {
        if(motion_detected) {
            pirService.UpdateMotionStatus(motion_detected);
            while(interval > 0) {
                wait(1);
                interval--;
            }
            motion_detected = 0;
            pirService.UpdateMotionStatus(motion_detected);
        }
    }
}