#include "mbed.h"
#include "SDFileSystem.h"
#include "MFRC522.h"
#include <stdio.h>
#include "NOKIA_5110.h"

// FRDM-K64F (Freescale) Pin for MFRC522 reset
#define MF_RESET    PTD0
FILE *fp;

DigitalOut LedGreen(LED2);

//Serial connection to PC for output
Serial pc(USBTX, USBRX); // serial comm on the FRDM board

//MFRC522    RfChip   (SPI_MOSI, SPI_MISO, SPI_SCK, SPI_CS, MF_RESET);
MFRC522    RfChip   (PTD2, PTD3, PTD1, PTE25, PTD0);

SDFileSystem sd(PTE3, PTE1, PTE2, PTE4, "sd"); // MOSI, MISO, SCK, CS
char buffer[1024]; 
uint8_t user[10];
char kanu[16]="BC02CD022B02702";
char abhishek[17]="6902BC029C021A02";
char temp[17];
int flag1=0;
int flag2=0; //checks if the card scanner is run for the first time

int main() 

{
    pc.printf("Initializing \n");
    
    LcdPins myPins;
    myPins.sce  = PTC12;
    myPins.rst  = PTC4;
    myPins.dc   = PTB3;
    myPins.mosi = PTD6;
    myPins.miso = NC;
    myPins.sclk = PTD5;
    
    NokiaLcd myLcd( myPins );
    
    // Start the LCD
    myLcd.InitLcd();
    myLcd.DrawString("HELLO");
    wait( 3 );
    myLcd.ShutdownLcd();
    
    // Init. RC522 Chip
    RfChip.PCD_Init();

   fp = fopen("/sd/attendance.txt", "r");
    if (fp != NULL) 
    {
        fclose(fp);
        remove("/sd/attendance.txt");
        pc.printf("Remove an existing file with the same name \n");
    }
   
while (true) 
{
    LedGreen = 1;

    // Look for new cards
    if ( ! RfChip.PICC_IsNewCardPresent())
    {
      RfChip.PCD_Init();
      wait_ms(300);
    //  continue;
    }

    // Select one of the cards
    if ( ! RfChip.PICC_ReadCardSerial())
    {
      wait_ms(200);
      continue;
    }

    LedGreen = 0;

    // Print Card UID
    printf("Card UID: ");
    for (uint8_t i = 0; i < RfChip.uid.size; i++)
    {
      printf("%X02", RfChip.uid.uidByte[i]);
      user[i]=RfChip.uid.uidByte[i];
    }
    printf("\n");

    sprintf(temp,"%X02%X02%X02%X02",user[0],user[1],user[2],user[3]);
    printf("temp is %s",temp);
    
    if(strcmp(temp, abhishek)==0)
        { 
            printf("\n found abhishek\n");
            if (flag2==1)
                {
               printf("Already logged in!\n");
                  
                myLcd.InitLcd();
                myLcd.DrawString("ABHISHEK");
                wait( 3 );
                myLcd.ShutdownLcd();
                
                }
            else if (flag2==0)
                {   
                    printf("\nWriting data to the sd card \n");
                    fp = fopen("/sd/attendance.txt", "a+");
                    if (fp == NULL) 
                        {
                            pc.printf("Unable to write the file \n");
                        } 
                    else 
                       {   
                        fprintf(fp, "\nAbhishek PRESENT \n");
                        fclose(fp); 
                       }        
            flag2=1;
                
                myLcd.InitLcd();
                myLcd.DrawString("ABHISHEK");
                wait( 3 );
                myLcd.ShutdownLcd();
               }
       }        
    else if(strcmp(temp,kanu)==0)
        { 
            printf("\n found Kanu\n");
            if (flag1==1)
                {
               printf("Already logged in!\n");
              
                myLcd.InitLcd();
                myLcd.DrawString("KANU");
                wait( 3 );
                myLcd.ShutdownLcd();
                
                }
            else if (flag1==0)
                {
                    printf("\nWriting data to the sd card \n");
                    fp = fopen("/sd/attendance.txt", "a+");
                    if (fp == NULL) 
                        {
                            pc.printf("Unable to write the file \n");
                        } 
                    else 
                    {    
                        fprintf(fp, "\nKANU PRESENT \n");
                        fclose(fp); 
                    }                       
            flag1=1;
            printf("flag1=%i\n",flag1);
        
                myLcd.InitLcd();
                myLcd.DrawString("KANU");
                wait( 3 );
                myLcd.ShutdownLcd();
            
               }
        
        printf("Just after continue\n");    
        }      
        
    else
        {
            continue;
        }      
    
    printf("\nReading data from the SD card. \n");
    fp = fopen("/sd/attendance.txt", "r");
    if (fp != NULL) 
    {
        int size = fread(buffer, sizeof(char), 1024, fp);
        printf("Number of data read: %d, text from attendance.txt file: %s \n", size, buffer);
        fclose(fp);
    }
}
}