#include "mbed.h"
#include "TextLCD.h"
#include "MQ2.h"
#include "DHT.h"
#include "hcsr04.h"
#include "FXOS8700Q.h"
AnalogIn sensor(A0);
DigitalOut Red(LED1);
DigitalOut Green(LED2);
DigitalOut Blue(LED3);
DigitalOut ledPin( PTD3 );
DigitalOut buzzer(D13);
MQ2 mq2(A1);  
DHT sensor1(D2, DHT11);
AnalogIn loudness(A3);
DigitalIn sw2(SW2);
DigitalIn sw3(SW3);
HCSR04  usensor(D10,D11);
I2C i2c(PTE25, PTE24);
unsigned int dist;

FXOS8700QAccelerometer acc(i2c, FXOS8700CQ_SLAVE_ADDR1);  
TextLCD lcd(D8, D9, D4, D5 ,D6 ,D7);
Serial pc(USBTX, USBRX);
int main() {
    motion_data_units_t acc_data;
    float faX, faY, faZ, fmX, fmY, fmZ, tmp_float;
    acc.enable();
    float s= 0.0f ,l=0.0f;
    mq2.begin();                                                                // 'Calibrate' sensor
    int a,b,e;
    float h = 0.0f, c = 0.0f, x = 0.0f, y = 0.0f;
    float val , R;
    ledPin=0;
    Red=1;
    Blue=1;
    Green=1;
    while(1) {
        acc.getAxis(acc_data);
        acc.getX(faX);
        acc.getY(faY);
        acc.getZ(faZ);
    a= mq2.readCO();
    b= mq2.readSmoke();  
  e = mq2.readLPG();
        s= loudness.read();
      l = (s*100000);
        val = sensor.read();
        R = (1023-val)*10/val;
        printf("Sensor reading: %2.2f\r\n", R/1000);
        sensor1.readData();
        x   = sensor1.ReadTemperature(CELCIUS);
        c = x/36;
        y   = sensor1.ReadHumidity();
        h = y/15;
        printf("Temperature is %0.00f, Humidity is %0.00f\r\n",c,h);
        if(R>40000)
        {
        lcd.cls();
        lcd.printf("Lights ON");
        printf("Turing on Indoor Light\r\n");
        ledPin = 1;
        }
        else {
            lcd.cls();
            lcd.printf("Lights OFF");
            printf("Optimal Lighting Indoor\r\n");
            ledPin = 0;
            }
        if(c>20){
            printf("Room is Hot and Humid at %0.00f and %0.00f\r\n",c,h);
            wait(1);
            lcd.cls();
            lcd.printf("Room is Hot and Humid");
            Red = !Red;
            wait(1);
            }
        else {
            
            wait(1);
            lcd.cls();
            lcd.printf("Good Temperature and Humidity");
            Red = 1;
            wait(1);
            }
        if(e||a||b>0)
        {
            wait(1);
            pc.printf("Gas Detected\r\n");
            lcd.cls();
            lcd.printf("Gas Detected");
            Green = !Green; 
            wait(1);
            }
        else{
            wait(1);
            pc.printf("NoGas Detected\r\n");
            lcd.cls();
            lcd.printf("No Gas Detected");
            Green = 1;
            wait(1);
            }
            wait(1);
        pc.printf("................................\r\n");                                           
        if(l<3600)
        {wait(1);
            printf("Music too loud\r\n");
            lcd.cls();
            lcd.printf("Music is Loud");
            }
        else{wait(1);
            printf("Sound is Good\r\n");
            lcd.cls();
            lcd.printf("Sound is Good");    
            }
         wait(1.0);
         wait(.5);
        if(faX<0){
        wait(.2);
         Blue = 0;
         printf("<<<<<<<<System is Moved in X-Axis>>>>>>>\r\n");
         wait(.5);
            lcd.cls();
            lcd.printf("System Moved");
            lcd.locate(0,1);
             lcd.printf("X-Axis");
             wait(.5);}
            else if(faY>0)
            {
            wait(.2);
             Blue = 0;
             printf("<<<<<<<<<<System is Moved in Y-Axis>>>>>>>>\r\n");
             wait(.5);
            lcd.cls();
            lcd.printf("System Moved");
            lcd.locate(0,1);
             lcd.printf("Y-Axis");
             wait(.5);}           
        else if(faZ<1){
         wait(.2);
         Blue = 0;
         wait(.5);
         printf("<<<<<<<<System is Moved in Z-Axis>>>>>>>>>>\r\n");
         wait(.5);
            lcd.cls();
            lcd.printf("System Moved");
            lcd.locate(0,1);
             lcd.printf("Z-Axis");
             wait(.5);}
         else {
         Blue = 1;
         wait(.5);
         printf("<<<<<System Safe>>>>>>\r\n");
            lcd.cls();
            lcd.printf("System Safe");
             wait(.5);}
           

}}

   