/*
The following program has been written to run on FRDM-K64F Board. But since 
the code is modular it can be run on any dev board with analog input and pwm 
output  functionality. Remember to update the port names correponding to the 
board and pin being used. 
Here, we have used a 3 terminal potentiometer with first connection to the 3.3V 
pin on the board, the second connection to A0 pin and the third one to the 
ground of the board. The PWM output pin (A5) is connected to 10K resistor in 
series with a LED. The negative teminal of LED is connected to the ground of the
board.  
*/
#include "mbed.h"

AnalogIn Pot(A0);  //Potentiometer Input Port PTB2
PwmOut PWM(A5); //PWM Output Port PTC10

Serial pc(USBTX,USBRX); //Used for serial communication

float period = 500; //the total width of the pwm
float x = 0; // to store the value from adc

int main()
{
    PWM.period_ms(period); //setting the pwm period width
    
    while(1)
    {
        x = Pot.read(); // the value of x will be between 0 and 1
        PWM.pulsewidth_ms(int(x*period)); //sets the duration of high during PWM
        pc.printf("Potentiometer Value =(%d)\r\n", x); //to see in terminal
        wait_ms(100); //General value based on desired speed of operation
     }
 }       
        