#ifndef NEOPIXEL_H
#define NEOPIXEL_H

#include "mbed.h"

#define NUM_PIXELS 5
#define NUM_COLORS_PER_PIXEL 3
#define NUM_BYTES_PER_COLOR 4
#define TOTAL_PIXEL_BYTES (NUM_BYTES_PER_COLOR*NUM_COLORS_PER_PIXEL*NUM_PIXELS)

enum BacklightStatus {
    BACKLIGHT_OK,
    BACKLIGHT_ERROR,
    BACKLIGHT_CONFIG,
    BACKLIGHT_OFF
};

class Backlight
{
public:
    /** Initialize a NeoPixel.
     *
     * @param mosiPin - transmit data on. Must be a SPI MOSI output
     */
    Backlight(PinName mosiPin);
    
    /** Updates the clock backlight status
     *
     *  @param status - sets the backlight based on predefined color pattern
     *                  matched with the status.
     */
    void UpdateBacklight(BacklightStatus status);
    
    /** Updates the bightness of the backlight.
     *
     * @param birghtness - float of brightness from 0.0 to 1.0
     *
     */
     void UpdateBrightness(float brightness);
     
private:
    SPI _bus;
    const uint8_t (*_statusColor)[NUM_COLORS_PER_PIXEL];
    float _brightness;
    uint8_t _rawPixelData[TOTAL_PIXEL_BYTES];
    uint8_t _rxBuffer[TOTAL_PIXEL_BYTES];
    
    void WritePixels(void);
    void CreateRawData(void);
    void WriteComplete(void);    
};

#endif