#include "mbed.h"
#include "Backlight.h"
#include "ColorDefs.h"

Backlight::Backlight(PinName mosiPin) : _bus(mosiPin,NC,D13) {
    
    _bus.format(8,1);
    _bus.frequency(3333333);  // 1/0.3us (4 pixels per out clock)
    _brightness = 1.0;
    
    _statusColor = COLOR_OFF;
 
    CreateRawData();   
    WritePixels();
}

void Backlight::UpdateBrightness(float brightness) {
    _brightness = brightness;
}

void Backlight::UpdateBacklight(BacklightStatus status) {
       
    switch(status) {
        case BACKLIGHT_OK:
            _statusColor = COLOR_OK;            
        break;
        case BACKLIGHT_CONFIG:
            _statusColor = COLOR_CONFIG;
        break;
        case BACKLIGHT_OFF:
            _statusColor = COLOR_OFF;
        break;
        case BACKLIGHT_ERROR:
        default:
            _statusColor = COLOR_ERROR;
        break;  
    }
    
    CreateRawData();   
    
    WritePixels();
}

void Backlight::CreateRawData(void) {
    // Encode '0' bits as 1000 and '1' bits as 1100.
    // Rearrange this partern: abcdefgh into this: 1a001b0001c001d001e001f001g001h00
    
    // 255 - 0xCCCCCCCC; 0 - 0x88888888
    
    uint32_t pixelColor,base;
    base = 0x88888888;
    
    for(int i = 0; i < NUM_PIXELS; i++) {
        for(int j = 0; j < NUM_COLORS_PER_PIXEL; j++) {
            uint32_t tempColor = (uint32_t)_statusColor[i][j]*_brightness;
            pixelColor  = (tempColor << 26) & 0x40000000;
            pixelColor |= (tempColor << 23) & 0x04000000;
            pixelColor |= (tempColor << 20) & 0x00400000;
            pixelColor |= (tempColor << 17) & 0x00040000;
            pixelColor |= (tempColor << 14) & 0x00004000;
            pixelColor |= (tempColor << 11) & 0x00000400;
            pixelColor |= (tempColor << 8)  & 0x00000040;
            pixelColor |= (tempColor << 5)  & 0x00000004;
            pixelColor |= base;
            // Invert signal since MOSI is idle high so idle can be 0
            pixelColor = ~pixelColor;       
            _rawPixelData[(i*NUM_BYTES_PER_COLOR*NUM_COLORS_PER_PIXEL)+(j*NUM_BYTES_PER_COLOR)]   = pixelColor & 0x000000FF;
            _rawPixelData[(i*NUM_BYTES_PER_COLOR*NUM_COLORS_PER_PIXEL)+(j*NUM_BYTES_PER_COLOR)+1] = (pixelColor >> 8)  & 0x000000FF;
            _rawPixelData[(i*NUM_BYTES_PER_COLOR*NUM_COLORS_PER_PIXEL)+(j*NUM_BYTES_PER_COLOR)+2] = (pixelColor >> 16) & 0x000000FF;
            _rawPixelData[(i*NUM_BYTES_PER_COLOR*NUM_COLORS_PER_PIXEL)+(j*NUM_BYTES_PER_COLOR)+3] = (pixelColor >> 24) & 0x000000FF;
        }
    }
}

void Backlight::WritePixels(void) {
    _bus.lock();
    _bus.write((char*)_rawPixelData,TOTAL_PIXEL_BYTES,(char*)_rxBuffer,TOTAL_PIXEL_BYTES);
    _bus.unlock();    
}
