#include "mbed.h"
#include "Backlight.h"
#include "ESP8266.h"

Serial pc(USBTX, USBRX);
Backlight backlight(D11);
ESP8266 esp(D1,D0,PTB20,115200,3000);

int main() {
    pc.baud(115200);
    pc.format(8,SerialBase::Odd,1);
    
    esp.init();
    Thread::wait(1000);

    esp.startStation();
    
    pc.printf("Getting AP List...");
 
    vector<APList> APs;
    esp.getAPList(&APs);
    
    pc.printf("Displaying %d APs\r\n",APs.size());
    
    for(vector<APList>::iterator it = APs.begin(); it != APs.end(); ++it) {
        pc.printf("%s\t%s\t%d\t%d\t%d\r\n",it->bssid, it->ssid, it->rssi,
                                               it->authMode, it->channel);    
    }
 
    pc.printf("Starting AP Mode...\r\n");

    esp.startOpenAP("NixieClock_Direct",1);
    
    esp.startWebServer();
      
//    if(esp.connect("Nicholas","narrowsocks233")) {
//        pc.printf("IP Address: %s\n",esp.getIPAddress());
//    } else {
//        printf("Connection failed\n");
//    }
    while(1) {
        Thread::wait(100);           
    }

}
