/**
 * Program an AVR with an mbed.
 */
 
// ATMega328 Datasheet:
//
//  http://www.atmel.com/dyn/resources/prod_documents/doc8271.pdf

#include "AVR910.h"

LocalFileSystem local("local");
Serial pc(USBTX, USBRX);

AVR910 mbedISP(p5, p6, p7, p8); //mosi, miso, sclk, nreset.

int main() {

    int success = -1;
    
    FILE *fp = fopen(PATH_TO_BINARY, "rb");
    
    if(fp == NULL){
        pc.printf("Failed to open binary. Please check the file path\n");
    }
    else{
        pc.printf("Binary file opened successfully\n");
        success = mbedISP.program(fp);
        fclose(fp);
    }
    
    if(success < 0){
        printf("Programming failed.\n");
    }
    else{
        printf("Programming was successful!\n");
    }
    
}
