/**
 * Program an AVR with an mbed.
 */

#include "AVR910.h"

LocalFileSystem local("local");
Serial pc(USBTX, USBRX);
AVR910 mAVRISP(p5, p6, p7, p8); //mosi, miso, sclk, nreset.

int main() {

    int success  = -1;
    int response =  0;

    //Read the vendor code [0x1E == Atmel].
    response = mAVRISP.readVendorCode();

    if (response == ATMEL_VENDOR_CODE) {
        pc.printf("Microcontroller is an Atmel [0x%02x]\n", response);
    } else if (response == DEVICE_LOCKED) {
        pc.printf("Device is locked\n");
        return -1;
    } else {
        pc.printf("Microcontroller is not an Atmel\n");
        return -1;
    }

    //Read part family and flash size - see datasheet for code meaning.
    response = mAVRISP.readPartFamilyAndFlashSize();

    if (response == 0xFF) {
        pc.printf("Device code erased or target missing\n");
    } else if (response == 0x01) {
        pc.printf("Device locked\n");
        return -1;
    } else {
        pc.printf("Part family and flash size code is: 0x%02x\n", response);
    }

    //Read part number.
    response = mAVRISP.readPartNumber();

    if (response == 0xFF) {
        pc.printf("Device code erased or target missing\n");
    } else if (response == 0x02) {
        pc.printf("Device locked\n");
        return -1;
    } else {
        pc.printf("Part number code is: 0x%02x\n", response);
    }

    //Open binary file to write to AVR.
    FILE *fp = fopen(PATH_TO_BINARY, "rb");

    if (fp == NULL) {
        pc.printf("Failed to open binary. Please check the file path\n");
        return -1;
    } else {
        //Program it!
        pc.printf("Binary file opened successfully\n");
        success = mAVRISP.program(fp,
                                  ATMEGA328P_PAGESIZE,
                                  ATMEGA328P_NUM_PAGES);
        fclose(fp);
    }

    if (success < 0) {
        printf("Programming failed.\n");
    } else {
        printf("Programming was successful!\n");
    }

}
