/**
 * Drive a robot forwards or backwards by supplying a PWM signal to
 * H-bridges connected to the motors.
 */

#include "Motor.h"
#include "QEI.h"

#define PULSES_PER_REVOLUTION 624

Motor leftMotor(p21, p20, p19);  //pwm, inB, inA
Motor rightMotor(p22, p17, p18); //pwm, inA, inB
QEI leftQei(p29, p30, NC, 624);  //chanA, chanB, index, ppr
QEI rightQei(p27, p28, NC, 624); //chanB, chanA, index, ppr

int main() {
    
    leftMotor.period(0.00005);  //Set motor PWM periods to 20KHz.
    rightMotor.period(0.00005);

    int leftPulses  = 0;    //How far the left wheel has travelled.
    int rightPulses = 0;    //How far the right wheel has travelled.
    int distance    = 6000; //Number of pulses to travel.

    wait(5); //Wait a few seconds before we start moving.
    
    leftMotor.speed(0.4);
    rightMotor.speed(0.4);
    
    while((leftPulses < distance) || (rightPulses < distance)){
    
        leftPulses  = leftQei.getPulses();
        rightPulses = rightQei.getPulses();
        
    }
    
    leftMotor.brake();
    rightMotor.brake();

}
