#include "SCA3000.h"

Serial pc(USBTX, USBRX);
SCA3000 accelerometer(p5, p6, p7, p8, p9);

int main() {

    pc.printf("Starting SCA3000 test...\n");
    
    int revision = accelerometer.getRevId();
    
    pc.printf("Device revision number is: %i.%i\n", revision & 0xF0, revision & 0x0F);
    
    
    while(1){
    
       //Arbitrary wait for printf clarity.
       wait(0.1);
       
       //Print out the acceleration measured on each axis in milli-gs.
       pc.printf("x:%f y:%f z:%f\n", accelerometer.getAcceleration(SCA3000_X_AXIS),
                                     accelerometer.getAcceleration(SCA3000_Y_AXIS),
                                     accelerometer.getAcceleration(SCA3000_Z_AXIS));

    }
    
}
