#include "IMUfilter.h"

Serial pc(USBTX, USBRX);

//Change the second parameter (which is a tuning parameter)
//to try and get optimal results. 
IMUfilter imuFilter(0.1, 10);

AnalogIn accelerometerX(p15);
AnalogIn accelerometerY(p16);
AnalogIn accelerometerZ(p17);
AnalogIn gyroscopeX(p18);
AnalogIn gyroscopeY(p19);
AnalogIn gyroscopeZ(p20);

int main() {

    while(1){
    
        wait(0.1);
        //Gyro and accelerometer values must be converted to rad/s and m/s/s
        //before being passed to the filter.
        imuFilter.updateFilter(gyroscopeX.read(),
                               gyroscopeY.read(),
                               gyroscopeZ.read(),
                               accelerometerX.read(),
                               accelerometerY.read(),
                               accelerometerZ.read());
        imuFilter.computeEuler();
        pc.printf("%f, %f, %f\n", imuFilter.getRoll(), imuFilter.getPitch(), imuFilter.getYaw());
    
    }

}
