/**
 * @file
 * @brief   Registers, Bit Masks and Bit Positions for the I2CM Peripheral Module.
 */

/* ****************************************************************************
 * Copyright (C) 2016 Maxim Integrated Products, Inc., All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL MAXIM INTEGRATED BE LIABLE FOR ANY CLAIM, DAMAGES
 * OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 *
 * Except as contained in this notice, the name of Maxim Integrated
 * Products, Inc. shall not be used except as stated in the Maxim Integrated
 * Products, Inc. Branding Policy.
 *
 * The mere transfer of this software does not imply any licenses
 * of trade secrets, proprietary technology, copyrights, patents,
 * trademarks, maskwork rights, or any other form of intellectual
 * property whatsoever. Maxim Integrated Products, Inc. retains all
 * ownership rights.
 *
 * $Date: 2016-10-10 18:58:15 -0500 (Mon, 10 Oct 2016) $
 * $Revision: 24660 $
 *
 *************************************************************************** */

/* Define to prevent redundant inclusion */
#ifndef _MXC_I2CM_REGS_H_
#define _MXC_I2CM_REGS_H_

/* **** Includes **** */
#include <stdint.h>

#ifdef __cplusplus
extern "C" {
#endif

///@cond
/*
    If types are not defined elsewhere (CMSIS) define them here
*/
#ifndef __IO
#define __IO volatile
#endif
#ifndef __I
#define __I  volatile const
#endif
#ifndef __O
#define __O  volatile
#endif
#ifndef __RO
#define __RO volatile const
#endif


#define MXC_S_I2CM_TRANS_TAG_START                0x000
#define MXC_S_I2CM_TRANS_TAG_TXDATA_ACK           0x100
#define MXC_S_I2CM_TRANS_TAG_TXDATA_NACK          0x200
#define MXC_S_I2CM_TRANS_TAG_RXDATA_COUNT         0x400
#define MXC_S_I2CM_TRANS_TAG_RXDATA_NACK          0x500
#define MXC_S_I2CM_TRANS_TAG_STOP                 0x700
#define MXC_S_I2CM_RSTLS_TAG_DATA                 0x100
#define MXC_S_I2CM_RSTLS_TAG_EMPTY                0x200
///@endcond

/**
 * @ingroup     i2cm
 * @defgroup    i2cm_registers Registers
 * @brief       Registers, Bit Masks and Bit Positions for the I2CM Peripheral Module.
 * @{
 */

/**
 * Structure type to access the I2CM Peripheral Module Registers
 */
typedef struct {
    __IO uint32_t fs_clk_div;                           /**< <tt>\b 0x0000        </tt> \b I2CM_FS_CLK_DIV Register - Full Speed SCL Clock Settings              */
    __RO uint32_t rsv004[2];                            /**< <tt>\b 0x0004-0x0008 </tt> \b RESERVED \warning Do Not Modify, Read Only                            */
    __IO uint32_t timeout;                              /**< <tt>\b 0x000C        </tt> \b I2CM_TIMEOUT Register - Timeout and Auto-Stop Settings                */
    __IO uint32_t ctrl;                                 /**< <tt>\b 0x0010        </tt> \b I2CM_CTRL Register - Master Control Register                          */
    __IO uint32_t trans;                                /**< <tt>\b 0x0014        </tt> \b I2CM_TRANS Register - Master Transaction Start and Status Flags       */
    __IO uint32_t intfl;                                /**< <tt>\b 0x0018        </tt> \b I2CM_INTFL Register - Master Interrupt Flags                          */
    __IO uint32_t inten;                                /**< <tt>\b 0x001C        </tt> \b I2CM_INTEN Register - Master Interrupt Enable/Disable Controls        */
    __RO uint32_t rsv020[2];                            /**< <tt>\b 0x0020-0x0024 </tt> \b RESERVED \warning Do Not Modify, Read Only                            */
    __IO uint32_t bb;                                   /**< <tt>\b 0x0028        </tt> \b I2CM_BB Register - Master Bit-Bang Control Register                   */
} mxc_i2cm_regs_t;


/**
 * Structure type for the I2CM Transmit and Receive FIFOs.
 * The @c tx member is the write location for transmitting data and @c rx member is the read point for reading data.
 * 
 */
typedef struct {
    union {                                             
        __IO uint16_t tx;                               /**< tx FIFO address */
        __IO uint8_t  tx_8[2048];                       /**< 8-bit access to TX FIFO */
        __IO uint16_t tx_16[1024];                      /**< 16-bit access to TX FIFO */
        __IO uint32_t tx_32[512];                       /**< 32-bit access to TX FIFO */
    };
    union {                                             
        __IO uint16_t rx;                               /**< RX FIFO address */
        __IO uint8_t  rx_8[2048];                       /**< 8-bit access to RX FIFO */
        __IO uint16_t rx_16[1024];                      /**< 16-bit access to RX FIFO */
        __IO uint32_t rx_32[512];                       /**< 32-bit access to RX FIFO */
    };
} mxc_i2cm_fifo_regs_t;
/**@} end of group i2cm_registers */

/*
   Register offsets for module I2CM.
*/
/**
 * @ingroup    i2cm_registers
 * @defgroup   I2CM_Register_Offsets Register Offsets
 * @brief      I2C Master Register Offsets from the I2CM[n] Base Peripheral Address. 
 * @{
 */
#define MXC_R_I2CM_OFFS_FS_CLK_DIV                          ((uint32_t)0x00000000UL)        /**< Offset from I2CM Base Address: <tt>\b 0x0000</tt> */
#define MXC_R_I2CM_OFFS_TIMEOUT                             ((uint32_t)0x0000000CUL)        /**< Offset from I2CM Base Address: <tt>\b 0x000C</tt> */
#define MXC_R_I2CM_OFFS_CTRL                                ((uint32_t)0x00000010UL)        /**< Offset from I2CM Base Address: <tt>\b 0x0010</tt> */
#define MXC_R_I2CM_OFFS_TRANS                               ((uint32_t)0x00000014UL)        /**< Offset from I2CM Base Address: <tt>\b 0x0014</tt> */
#define MXC_R_I2CM_OFFS_INTFL                               ((uint32_t)0x00000018UL)        /**< Offset from I2CM Base Address: <tt>\b 0x0018</tt> */
#define MXC_R_I2CM_OFFS_INTEN                               ((uint32_t)0x0000001CUL)        /**< Offset from I2CM Base Address: <tt>\b 0x001C</tt> */
#define MXC_R_I2CM_OFFS_BB                                  ((uint32_t)0x00000028UL)        /**< Offset from I2CM Base Address: <tt>\b 0x0028</tt> */
#define MXC_R_I2CM_FIFO_OFFS_TRANS                          ((uint32_t)0x00000000UL)        /**< Offset from I2CM FIFO Base Address: <tt>\b 0x0000</tt> */
#define MXC_R_I2CM_FIFO_OFFS_RSLTS                          ((uint32_t)0x00000800UL)        /**< Offset from I2CM FIFO Base Address: <tt>\b 0x8000</tt> */
/**@} end of group i2cm_registers */

/*
   Field positions and masks for module I2CM.
*/
/**
 * @ingroup  i2cm_registers
 * @defgroup I2CM_FS_CLK_DIV_Register I2CM_FS_CLK_DIV
 * @brief    Field Positions and Bit Masks for the I2CM_FS_CLK_DIV register
 * @{
 */
#define MXC_F_I2CM_FS_CLK_DIV_FS_FILTER_CLK_DIV_POS         0                                                                           /**< FS_FILTER_CLK_DIV Position */
#define MXC_F_I2CM_FS_CLK_DIV_FS_FILTER_CLK_DIV             ((uint32_t)(0x000000FFUL << MXC_F_I2CM_FS_CLK_DIV_FS_FILTER_CLK_DIV_POS))   /**< FS_FILTER_CLK_DIV Mask */         
#define MXC_F_I2CM_FS_CLK_DIV_FS_SCL_LO_CNT_POS             8                                                                           /**< FS_SCL_LO_CNT Position */
#define MXC_F_I2CM_FS_CLK_DIV_FS_SCL_LO_CNT                 ((uint32_t)(0x00000FFFUL << MXC_F_I2CM_FS_CLK_DIV_FS_SCL_LO_CNT_POS))       /**< FS_SCL_LO_CNT Mask */     
#define MXC_F_I2CM_FS_CLK_DIV_FS_SCL_HI_CNT_POS             20                                                                          /**< FS_SCL_HI_CNT Position */
#define MXC_F_I2CM_FS_CLK_DIV_FS_SCL_HI_CNT                 ((uint32_t)(0x00000FFFUL << MXC_F_I2CM_FS_CLK_DIV_FS_SCL_HI_CNT_POS))       /**< FS_SCL_HI_CNT Mask */     
/**@}*/
/**
 * @ingroup  i2cm_registers
 * @defgroup I2CM_TIMEOUT_Register I2CM_TIMEOUT
 * @brief    Field Positions and Bit Masks for the I2CM_TIMEOUT register
 * @{
 */    
#define MXC_F_I2CM_TIMEOUT_TX_TIMEOUT_POS                   16                                                                          /**< TX_TIMEOUT Position */
#define MXC_F_I2CM_TIMEOUT_TX_TIMEOUT                       ((uint32_t)(0x000000FFUL << MXC_F_I2CM_TIMEOUT_TX_TIMEOUT_POS))             /**< TX_TIMEOUT Mask */
#define MXC_F_I2CM_TIMEOUT_AUTO_STOP_EN_POS                 24                                                                          /**< AUTO_STOP_EN Position */
#define MXC_F_I2CM_TIMEOUT_AUTO_STOP_EN                     ((uint32_t)(0x00000001UL << MXC_F_I2CM_TIMEOUT_AUTO_STOP_EN_POS))           /**< AUTO_STOP_EN Mask */ 
/**@}*/
/**
 * @ingroup  i2cm_registers
 * @defgroup I2CM_CTRL_Register I2CM_CTRL
 * @brief    Field Positions and Bit Masks for the I2CM_CTRL register
 * @{
 */
#define MXC_F_I2CM_CTRL_TX_FIFO_EN_POS                      2                                                                           /**< TX_FIFO_EN Position */
#define MXC_F_I2CM_CTRL_TX_FIFO_EN                          ((uint32_t)(0x00000001UL << MXC_F_I2CM_CTRL_TX_FIFO_EN_POS))                /**< TX_FIFO_EN Mask */
#define MXC_F_I2CM_CTRL_RX_FIFO_EN_POS                      3                                                                           /**< RX_FIFO_EN Position */
#define MXC_F_I2CM_CTRL_RX_FIFO_EN                          ((uint32_t)(0x00000001UL << MXC_F_I2CM_CTRL_RX_FIFO_EN_POS))                /**< RX_FIFO_EN Mask */
#define MXC_F_I2CM_CTRL_MSTR_RESET_EN_POS                   7                                                                           /**< MSTR_RESET_EN Position */
#define MXC_F_I2CM_CTRL_MSTR_RESET_EN                       ((uint32_t)(0x00000001UL << MXC_F_I2CM_CTRL_MSTR_RESET_EN_POS))             /**< MSTR_RESET_EN Mask */
/**@}*/
/**
 * @ingroup  i2cm_registers
 * @defgroup I2CM_TRANS_Register I2CM_TRANS
 * @brief    Field Positions and Bit Masks for the I2CM_TRANS register
 * @{
 */
#define MXC_F_I2CM_TRANS_TX_START_POS                       0                                                                           /**< TX_START Position */
#define MXC_F_I2CM_TRANS_TX_START                           ((uint32_t)(0x00000001UL << MXC_F_I2CM_TRANS_TX_START_POS))                 /**< TX_START Mask */
#define MXC_F_I2CM_TRANS_TX_IN_PROGRESS_POS                 1                                                                           /**< TX_IN_PROGRESS Position */
#define MXC_F_I2CM_TRANS_TX_IN_PROGRESS                     ((uint32_t)(0x00000001UL << MXC_F_I2CM_TRANS_TX_IN_PROGRESS_POS))           /**< TX_IN_PROGRESS Mask */ 
#define MXC_F_I2CM_TRANS_TX_DONE_POS                        2                                                                           /**< TX_DONE Position */
#define MXC_F_I2CM_TRANS_TX_DONE                            ((uint32_t)(0x00000001UL << MXC_F_I2CM_TRANS_TX_DONE_POS))                  /**< TX_DONE Mask */
#define MXC_F_I2CM_TRANS_TX_NACKED_POS                      3                                                                           /**< TX_NACKED Position */
#define MXC_F_I2CM_TRANS_TX_NACKED                          ((uint32_t)(0x00000001UL << MXC_F_I2CM_TRANS_TX_NACKED_POS))                /**< TX_NACKED Mask */
#define MXC_F_I2CM_TRANS_TX_LOST_ARBITR_POS                 4                                                                           /**< TX_LOST_ARBITR Position */
#define MXC_F_I2CM_TRANS_TX_LOST_ARBITR                     ((uint32_t)(0x00000001UL << MXC_F_I2CM_TRANS_TX_LOST_ARBITR_POS))           /**< TX_LOST_ARBITR Mask */ 
#define MXC_F_I2CM_TRANS_TX_TIMEOUT_POS                     5                                                                           /**< TX_TIMEOUT Position */
#define MXC_F_I2CM_TRANS_TX_TIMEOUT                         ((uint32_t)(0x00000001UL << MXC_F_I2CM_TRANS_TX_TIMEOUT_POS))               /**< TX_TIMEOUT Mask */
/**@}*/
/**
 * @ingroup  i2cm_registers
 * @defgroup I2CM_INTFL_Register I2CM_INTFL
 * @brief    Field Positions and Bit Masks for the I2CM_INTFL register
 * @{
 */
#define MXC_F_I2CM_INTFL_TX_DONE_POS                        0                                                                           /**< TX_DONE Position */
#define MXC_F_I2CM_INTFL_TX_DONE                            ((uint32_t)(0x00000001UL << MXC_F_I2CM_INTFL_TX_DONE_POS))                  /**< TX_DONE Mask */
#define MXC_F_I2CM_INTFL_TX_NACKED_POS                      1                                                                           /**< TX_NACKED Position */
#define MXC_F_I2CM_INTFL_TX_NACKED                          ((uint32_t)(0x00000001UL << MXC_F_I2CM_INTFL_TX_NACKED_POS))                /**< TX_NACKED Mask */
#define MXC_F_I2CM_INTFL_TX_LOST_ARBITR_POS                 2                                                                           /**< TX_LOST_ARBITR Position */
#define MXC_F_I2CM_INTFL_TX_LOST_ARBITR                     ((uint32_t)(0x00000001UL << MXC_F_I2CM_INTFL_TX_LOST_ARBITR_POS))           /**< TX_LOST_ARBITR Mask */ 
#define MXC_F_I2CM_INTFL_TX_TIMEOUT_POS                     3                                                                           /**< TX_TIMEOUT Position */
#define MXC_F_I2CM_INTFL_TX_TIMEOUT                         ((uint32_t)(0x00000001UL << MXC_F_I2CM_INTFL_TX_TIMEOUT_POS))               /**< TX_TIMEOUT Mask */
#define MXC_F_I2CM_INTFL_TX_FIFO_EMPTY_POS                  4                                                                           /**< TX_FIFO_EMPTY Position */
#define MXC_F_I2CM_INTFL_TX_FIFO_EMPTY                      ((uint32_t)(0x00000001UL << MXC_F_I2CM_INTFL_TX_FIFO_EMPTY_POS))            /**< TX_FIFO_EMPTY Mask */ 
#define MXC_F_I2CM_INTFL_TX_FIFO_3Q_EMPTY_POS               5                                                                           /**< TX_FIFO_3Q_EMPTY Position */
#define MXC_F_I2CM_INTFL_TX_FIFO_3Q_EMPTY                   ((uint32_t)(0x00000001UL << MXC_F_I2CM_INTFL_TX_FIFO_3Q_EMPTY_POS))         /**< TX_FIFO_3Q_EMPTY Mask */ 
#define MXC_F_I2CM_INTFL_RX_FIFO_NOT_EMPTY_POS              6                                                                           /**< RX_FIFO_NOT_EMPTY Position */
#define MXC_F_I2CM_INTFL_RX_FIFO_NOT_EMPTY                  ((uint32_t)(0x00000001UL << MXC_F_I2CM_INTFL_RX_FIFO_NOT_EMPTY_POS))        /**< RX_FIFO_NOT_EMPTY Mask */     
#define MXC_F_I2CM_INTFL_RX_FIFO_2Q_FULL_POS                7                                                                           /**< RX_FIFO_2Q_FULL Position */
#define MXC_F_I2CM_INTFL_RX_FIFO_2Q_FULL                    ((uint32_t)(0x00000001UL << MXC_F_I2CM_INTFL_RX_FIFO_2Q_FULL_POS))          /**< RX_FIFO_2Q_FULL Mask */ 
#define MXC_F_I2CM_INTFL_RX_FIFO_3Q_FULL_POS                8                                                                           /**< RX_FIFO_3Q_FULL Position */
#define MXC_F_I2CM_INTFL_RX_FIFO_3Q_FULL                    ((uint32_t)(0x00000001UL << MXC_F_I2CM_INTFL_RX_FIFO_3Q_FULL_POS))          /**< RX_FIFO_3Q_FULL Mask */ 
#define MXC_F_I2CM_INTFL_RX_FIFO_FULL_POS                   9                                                                           /**< RX_FIFO_FULL Position */
#define MXC_F_I2CM_INTFL_RX_FIFO_FULL                       ((uint32_t)(0x00000001UL << MXC_F_I2CM_INTFL_RX_FIFO_FULL_POS))             /**< RX_FIFO_FULL Mask */
/**@}*/
/**
 * @ingroup  i2cm_registers
 * @defgroup I2CM_INTEN_Register I2CM_INTEN
 * @brief    Field Positions and Bit Masks for the I2CM_INTEN register
 * @{
 */
#define MXC_F_I2CM_INTEN_TX_DONE_POS                        0                                                                           /**< TX_DONE Position */
#define MXC_F_I2CM_INTEN_TX_DONE                            ((uint32_t)(0x00000001UL << MXC_F_I2CM_INTEN_TX_DONE_POS))                  /**< TX_DONE Mask */
#define MXC_F_I2CM_INTEN_TX_NACKED_POS                      1                                                                           /**< TX_NACKED Position */
#define MXC_F_I2CM_INTEN_TX_NACKED                          ((uint32_t)(0x00000001UL << MXC_F_I2CM_INTEN_TX_NACKED_POS))                /**< TX_NACKED Mask */
#define MXC_F_I2CM_INTEN_TX_LOST_ARBITR_POS                 2                                                                           /**< TX_LOST_ARBITR Position */
#define MXC_F_I2CM_INTEN_TX_LOST_ARBITR                     ((uint32_t)(0x00000001UL << MXC_F_I2CM_INTEN_TX_LOST_ARBITR_POS))           /**< TX_LOST_ARBITR Mask */ 
#define MXC_F_I2CM_INTEN_TX_TIMEOUT_POS                     3                                                                           /**< TX_TIMEOUT Position */
#define MXC_F_I2CM_INTEN_TX_TIMEOUT                         ((uint32_t)(0x00000001UL << MXC_F_I2CM_INTEN_TX_TIMEOUT_POS))               /**< TX_TIMEOUT Mask */
#define MXC_F_I2CM_INTEN_TX_FIFO_EMPTY_POS                  4                                                                           /**< TX_FIFO_EMPTY Position */
#define MXC_F_I2CM_INTEN_TX_FIFO_EMPTY                      ((uint32_t)(0x00000001UL << MXC_F_I2CM_INTEN_TX_FIFO_EMPTY_POS))            /**< TX_FIFO_EMPTY Mask */ 
#define MXC_F_I2CM_INTEN_TX_FIFO_3Q_EMPTY_POS               5                                                                           /**< TX_FIFO_3Q_EMPTY Position */
#define MXC_F_I2CM_INTEN_TX_FIFO_3Q_EMPTY                   ((uint32_t)(0x00000001UL << MXC_F_I2CM_INTEN_TX_FIFO_3Q_EMPTY_POS))         /**< TX_FIFO_3Q_EMPTY Mask */ 
#define MXC_F_I2CM_INTEN_RX_FIFO_NOT_EMPTY_POS              6                                                                           /**< RX_FIFO_NOT_EMPTY Position */
#define MXC_F_I2CM_INTEN_RX_FIFO_NOT_EMPTY                  ((uint32_t)(0x00000001UL << MXC_F_I2CM_INTEN_RX_FIFO_NOT_EMPTY_POS))        /**< RX_FIFO_NOT_EMPTY Mask */     
#define MXC_F_I2CM_INTEN_RX_FIFO_2Q_FULL_POS                7                                                                           /**< RX_FIFO_2Q_FULL Position */
#define MXC_F_I2CM_INTEN_RX_FIFO_2Q_FULL                    ((uint32_t)(0x00000001UL << MXC_F_I2CM_INTEN_RX_FIFO_2Q_FULL_POS))          /**< RX_FIFO_2Q_FULL Mask */ 
#define MXC_F_I2CM_INTEN_RX_FIFO_3Q_FULL_POS                8                                                                           /**< RX_FIFO_3Q_FULL Position */
#define MXC_F_I2CM_INTEN_RX_FIFO_3Q_FULL                    ((uint32_t)(0x00000001UL << MXC_F_I2CM_INTEN_RX_FIFO_3Q_FULL_POS))          /**< RX_FIFO_3Q_FULL Mask */ 
#define MXC_F_I2CM_INTEN_RX_FIFO_FULL_POS                   9                                                                           /**< RX_FIFO_FULL Position */
#define MXC_F_I2CM_INTEN_RX_FIFO_FULL                       ((uint32_t)(0x00000001UL << MXC_F_I2CM_INTEN_RX_FIFO_FULL_POS))             /**< RX_FIFO_FULL Mask */
/**@}*/
/**
 * @ingroup  i2cm_registers
 * @defgroup I2CM_BB_Register I2CM_BB
 * @brief    Field Positions and Bit Masks for the I2CM_BB register
 * @{
 */
#define MXC_F_I2CM_BB_BB_SCL_OUT_POS                        0                                                                           /**< BB_SCL_OUT Position */
#define MXC_F_I2CM_BB_BB_SCL_OUT                            ((uint32_t)(0x00000001UL << MXC_F_I2CM_BB_BB_SCL_OUT_POS))                  /**< BB_SCL_OUT Mask */
#define MXC_F_I2CM_BB_BB_SDA_OUT_POS                        1                                                                           /**< BB_SDA_OUT Position */
#define MXC_F_I2CM_BB_BB_SDA_OUT                            ((uint32_t)(0x00000001UL << MXC_F_I2CM_BB_BB_SDA_OUT_POS))                  /**< BB_SDA_OUT Mask */
#define MXC_F_I2CM_BB_BB_SCL_IN_VAL_POS                     2                                                                           /**< BB_SCL_IN_VAL Position */
#define MXC_F_I2CM_BB_BB_SCL_IN_VAL                         ((uint32_t)(0x00000001UL << MXC_F_I2CM_BB_BB_SCL_IN_VAL_POS))               /**< BB_SCL_IN_VAL Mask */
#define MXC_F_I2CM_BB_BB_SDA_IN_VAL_POS                     3                                                                           /**< BB_SDA_IN_VAL Position */
#define MXC_F_I2CM_BB_BB_SDA_IN_VAL                         ((uint32_t)(0x00000001UL << MXC_F_I2CM_BB_BB_SDA_IN_VAL_POS))               /**< BB_SDA_IN_VAL Mask */
#define MXC_F_I2CM_BB_RX_FIFO_CNT_POS                       16                                                                          /**< RX_FIFO_CNT Position */
#define MXC_F_I2CM_BB_RX_FIFO_CNT                           ((uint32_t)(0x0000001FUL << MXC_F_I2CM_BB_RX_FIFO_CNT_POS))                 /**< RX_FIFO_CNT Mask */
/**@}*/


#ifdef __cplusplus
}
#endif

#endif   /* _MXC_I2CM_REGS_H_ */


