/**
 * \file
 *
 * \brief SAM SERCOM Module Pinout Definitions
 *
 * Copyright (C) 2012-2015 Atmel Corporation. All rights reserved.
 *
 * \asf_license_start
 *
 * \page License
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 * 3. The name of Atmel may not be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * 4. This software may only be redistributed and used in connection with an
 *    Atmel microcontroller product.
 *
 * THIS SOFTWARE IS PROVIDED BY ATMEL "AS IS" AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT ARE
 * EXPRESSLY AND SPECIFICALLY DISCLAIMED. IN NO EVENT SHALL ATMEL BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
 * ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * \asf_license_stop
 *
 */
/*
 * Support and FAQ: visit <a href="http://www.atmel.com/design-support/">Atmel Support</a>
 */
#ifndef SERCOM_PINOUT_H_INCLUDED
#define SERCOM_PINOUT_H_INCLUDED

#include <compiler.h>

#if SAMR21E
/* SERCOM0 */
#define SERCOM0_PAD0_DEFAULT      PINMUX_PA08C_SERCOM0_PAD0
#define SERCOM0_PAD1_DEFAULT      PINMUX_PA09C_SERCOM0_PAD1
#define SERCOM0_PAD2_DEFAULT      PINMUX_PA06D_SERCOM0_PAD2
#define SERCOM0_PAD3_DEFAULT      PINMUX_PA07D_SERCOM0_PAD3

/* SERCOM1 */
#define SERCOM1_PAD0_DEFAULT      PINMUX_PA16C_SERCOM1_PAD0
#define SERCOM1_PAD1_DEFAULT      PINMUX_PA17C_SERCOM1_PAD1
#define SERCOM1_PAD2_DEFAULT      PINMUX_PA18C_SERCOM1_PAD2
#define SERCOM1_PAD3_DEFAULT      PINMUX_PA19C_SERCOM1_PAD3

/* SERCOM2 */
#define SERCOM2_PAD0_DEFAULT      PINMUX_PA08D_SERCOM2_PAD0
#define SERCOM2_PAD1_DEFAULT      PINMUX_PA09D_SERCOM2_PAD1
#define SERCOM2_PAD2_DEFAULT      PINMUX_PA14C_SERCOM2_PAD2
#define SERCOM2_PAD3_DEFAULT      PINMUX_PA15C_SERCOM2_PAD3

/* SERCOM3 */
#define SERCOM3_PAD0_DEFAULT      PINMUX_PA27F_SERCOM3_PAD0
#define SERCOM3_PAD1_DEFAULT      PINMUX_PA28F_SERCOM3_PAD1
#define SERCOM3_PAD2_DEFAULT      PINMUX_PA24C_SERCOM3_PAD2
#define SERCOM3_PAD3_DEFAULT      PINMUX_PA25C_SERCOM3_PAD3

/* SERCOM4 */
#define SERCOM4_PAD0_DEFAULT      PINMUX_PC19F_SERCOM4_PAD0
#define SERCOM4_PAD1_DEFAULT      PINMUX_PB31F_SERCOM4_PAD1
#define SERCOM4_PAD2_DEFAULT      PINMUX_PB30F_SERCOM4_PAD2
#define SERCOM4_PAD3_DEFAULT      PINMUX_PC18F_SERCOM4_PAD3

/* SERCOM5 */
#define SERCOM5_PAD0_DEFAULT      PINMUX_PB30D_SERCOM5_PAD0
#define SERCOM5_PAD1_DEFAULT      PINMUX_PB31D_SERCOM5_PAD1
#define SERCOM5_PAD2_DEFAULT      PINMUX_PA24D_SERCOM5_PAD2
#define SERCOM5_PAD3_DEFAULT      PINMUX_PA25D_SERCOM5_PAD3

#elif SAMR21G
/* SERCOM0 */
#define SERCOM0_PAD0_DEFAULT      PINMUX_PA04D_SERCOM0_PAD0
#define SERCOM0_PAD1_DEFAULT      PINMUX_PA05D_SERCOM0_PAD1
#define SERCOM0_PAD2_DEFAULT      PINMUX_PA06D_SERCOM0_PAD2
#define SERCOM0_PAD3_DEFAULT      PINMUX_PA07D_SERCOM0_PAD3

/* SERCOM1 */
#define SERCOM1_PAD0_DEFAULT      PINMUX_PA00D_SERCOM1_PAD0
#define SERCOM1_PAD1_DEFAULT      PINMUX_PA01D_SERCOM1_PAD1
#define SERCOM1_PAD2_DEFAULT      PINMUX_PA30D_SERCOM1_PAD2
#define SERCOM1_PAD3_DEFAULT      PINMUX_PA31D_SERCOM1_PAD3

/* SERCOM2 */
#define SERCOM2_PAD0_DEFAULT      PINMUX_PA12C_SERCOM2_PAD0
#define SERCOM2_PAD1_DEFAULT      PINMUX_PA13C_SERCOM2_PAD1
#define SERCOM2_PAD2_DEFAULT      PINMUX_PA14C_SERCOM2_PAD2
#define SERCOM2_PAD3_DEFAULT      PINMUX_PA15C_SERCOM2_PAD3

/* SERCOM3 */
#define SERCOM3_PAD0_DEFAULT      PINMUX_PA16D_SERCOM3_PAD0
#define SERCOM3_PAD1_DEFAULT      PINMUX_PA17D_SERCOM3_PAD1
#define SERCOM3_PAD2_DEFAULT      PINMUX_PA18D_SERCOM3_PAD2
#define SERCOM3_PAD3_DEFAULT      PINMUX_PA19D_SERCOM3_PAD3

/* SERCOM4 */
#define SERCOM4_PAD0_DEFAULT      PINMUX_PC19F_SERCOM4_PAD0
#define SERCOM4_PAD1_DEFAULT      PINMUX_PB31F_SERCOM4_PAD1
#define SERCOM4_PAD2_DEFAULT      PINMUX_PB30F_SERCOM4_PAD2
#define SERCOM4_PAD3_DEFAULT      PINMUX_PC18F_SERCOM4_PAD3

/* SERCOM5 */
#define SERCOM5_PAD0_DEFAULT      PINMUX_PA22D_SERCOM5_PAD0
#define SERCOM5_PAD1_DEFAULT      PINMUX_PA23D_SERCOM5_PAD1
#define SERCOM5_PAD2_DEFAULT      PINMUX_PA24D_SERCOM5_PAD2
#define SERCOM5_PAD3_DEFAULT      PINMUX_PA25D_SERCOM5_PAD3

#elif (SAMD10) || (SAMD11)
/* SERCOM0 */
#define SERCOM0_PAD0_DEFAULT      PINMUX_PA04D_SERCOM0_PAD0
#define SERCOM0_PAD1_DEFAULT      PINMUX_PA05D_SERCOM0_PAD1
#define SERCOM0_PAD2_DEFAULT      PINMUX_PA06D_SERCOM0_PAD2
#define SERCOM0_PAD3_DEFAULT      PINMUX_PA07D_SERCOM0_PAD3

/* SERCOM1 */
#define SERCOM1_PAD0_DEFAULT      PINMUX_PA22C_SERCOM1_PAD0
#define SERCOM1_PAD1_DEFAULT      PINMUX_PA23C_SERCOM1_PAD1
#define SERCOM1_PAD2_DEFAULT      PINMUX_PA30D_SERCOM1_PAD2
#define SERCOM1_PAD3_DEFAULT      PINMUX_PA31D_SERCOM1_PAD3

/* SERCOM2 */
#define SERCOM2_PAD0_DEFAULT      PINMUX_PA22D_SERCOM2_PAD0
#define SERCOM2_PAD1_DEFAULT      PINMUX_PA23D_SERCOM2_PAD1
#define SERCOM2_PAD2_DEFAULT      PINMUX_PA16D_SERCOM2_PAD2
#define SERCOM2_PAD3_DEFAULT      PINMUX_PA25D_SERCOM2_PAD3

#elif SAM_PART_IS_DEFINED(SAMD21E15L) || SAM_PART_IS_DEFINED(SAMD21E16L)

/* SERCOM0 */
#define SERCOM0_PAD0_DEFAULT      PINMUX_PA04D_SERCOM0_PAD0
#define SERCOM0_PAD1_DEFAULT      PINMUX_PA05D_SERCOM0_PAD1
#define SERCOM0_PAD2_DEFAULT      PINMUX_PA06D_SERCOM0_PAD2
#define SERCOM0_PAD3_DEFAULT      PINMUX_PA07D_SERCOM0_PAD3

/* SERCOM1 */
#define SERCOM1_PAD0_DEFAULT      PINMUX_PA16C_SERCOM1_PAD0
#define SERCOM1_PAD1_DEFAULT      PINMUX_PA17C_SERCOM1_PAD1
#define SERCOM1_PAD2_DEFAULT      PINMUX_PA18C_SERCOM1_PAD2
#define SERCOM1_PAD3_DEFAULT      PINMUX_PA19C_SERCOM1_PAD3

/* SERCOM2 */
#define SERCOM2_PAD0_DEFAULT      PINMUX_PA08D_SERCOM2_PAD0
#define SERCOM2_PAD1_DEFAULT      PINMUX_PA09D_SERCOM2_PAD1
#define SERCOM2_PAD2_DEFAULT      PINMUX_PA10D_SERCOM2_PAD2
#define SERCOM2_PAD3_DEFAULT      PINMUX_PA11D_SERCOM2_PAD3

/* SERCOM3 */
#define SERCOM3_PAD0_DEFAULT      PINMUX_PA22C_SERCOM3_PAD0
#define SERCOM3_PAD1_DEFAULT      PINMUX_PA23C_SERCOM3_PAD1
#define SERCOM3_PAD2_DEFAULT      PINMUX_PA24C_SERCOM3_PAD2
#define SERCOM3_PAD3_DEFAULT      PINMUX_PA25C_SERCOM3_PAD3

#elif (SAMC20E) || (SAMC21E)
/* SERCOM0 */
#define SERCOM0_PAD0_DEFAULT      PINMUX_PA04D_SERCOM0_PAD0
#define SERCOM0_PAD1_DEFAULT      PINMUX_PA05D_SERCOM0_PAD1
#define SERCOM0_PAD2_DEFAULT      PINMUX_PA06D_SERCOM0_PAD2
#define SERCOM0_PAD3_DEFAULT      PINMUX_PA07D_SERCOM0_PAD3

/* SERCOM1 */
#define SERCOM1_PAD0_DEFAULT      PINMUX_PA16C_SERCOM1_PAD0
#define SERCOM1_PAD1_DEFAULT      PINMUX_PA17C_SERCOM1_PAD1
#define SERCOM1_PAD2_DEFAULT      PINMUX_PA18C_SERCOM1_PAD2
#define SERCOM1_PAD3_DEFAULT      PINMUX_PA19C_SERCOM1_PAD3

/* SERCOM2 */
#define SERCOM2_PAD0_DEFAULT      PINMUX_PA08D_SERCOM2_PAD0
#define SERCOM2_PAD1_DEFAULT      PINMUX_PA09D_SERCOM2_PAD1
#define SERCOM2_PAD2_DEFAULT      PINMUX_PA10D_SERCOM2_PAD2
#define SERCOM2_PAD3_DEFAULT      PINMUX_PA11D_SERCOM2_PAD3

/* SERCOM3 */
#define SERCOM3_PAD0_DEFAULT      PINMUX_PA22C_SERCOM3_PAD0
#define SERCOM3_PAD1_DEFAULT      PINMUX_PA23C_SERCOM3_PAD1
#define SERCOM3_PAD2_DEFAULT      PINMUX_PA24C_SERCOM3_PAD2
#define SERCOM3_PAD3_DEFAULT      PINMUX_PA25C_SERCOM3_PAD3

#elif (SAMC20G) || (SAMC21G)
/* SERCOM0 */
#define SERCOM0_PAD0_DEFAULT      PINMUX_PA04D_SERCOM0_PAD0
#define SERCOM0_PAD1_DEFAULT      PINMUX_PA05D_SERCOM0_PAD1
#define SERCOM0_PAD2_DEFAULT      PINMUX_PA06D_SERCOM0_PAD2
#define SERCOM0_PAD3_DEFAULT      PINMUX_PA07D_SERCOM0_PAD3

/* SERCOM1 */
#define SERCOM1_PAD0_DEFAULT      PINMUX_PA16C_SERCOM1_PAD0
#define SERCOM1_PAD1_DEFAULT      PINMUX_PA17C_SERCOM1_PAD1
#define SERCOM1_PAD2_DEFAULT      PINMUX_PA18C_SERCOM1_PAD2
#define SERCOM1_PAD3_DEFAULT      PINMUX_PA19C_SERCOM1_PAD3

/* SERCOM2 */
#define SERCOM2_PAD0_DEFAULT      PINMUX_PA12C_SERCOM2_PAD0
#define SERCOM2_PAD1_DEFAULT      PINMUX_PA13C_SERCOM2_PAD1
#define SERCOM2_PAD2_DEFAULT      PINMUX_PA14C_SERCOM2_PAD2
#define SERCOM2_PAD3_DEFAULT      PINMUX_PA15C_SERCOM2_PAD3

/* SERCOM3 */
#define SERCOM3_PAD0_DEFAULT      PINMUX_PA22C_SERCOM3_PAD0
#define SERCOM3_PAD1_DEFAULT      PINMUX_PA23C_SERCOM3_PAD1
#define SERCOM3_PAD2_DEFAULT      PINMUX_PA24C_SERCOM3_PAD2
#define SERCOM3_PAD3_DEFAULT      PINMUX_PA25C_SERCOM3_PAD3

#ifdef ID_SERCOM4
/* SERCOM4 */
#define SERCOM4_PAD0_DEFAULT      PINMUX_PB08D_SERCOM4_PAD0
#define SERCOM4_PAD1_DEFAULT      PINMUX_PB09D_SERCOM4_PAD1
#define SERCOM4_PAD2_DEFAULT      PINMUX_PB10D_SERCOM4_PAD2
#define SERCOM4_PAD3_DEFAULT      PINMUX_PB11D_SERCOM4_PAD3
#endif

#ifdef ID_SERCOM5
/* SERCOM5 */
#define SERCOM5_PAD0_DEFAULT      PINMUX_PB02D_SERCOM5_PAD0
#define SERCOM5_PAD1_DEFAULT      PINMUX_PB03D_SERCOM5_PAD1
#define SERCOM5_PAD2_DEFAULT      PINMUX_PB22D_SERCOM5_PAD2
#define SERCOM5_PAD3_DEFAULT      PINMUX_PB23D_SERCOM5_PAD3
#endif

#elif (SAMC20J) || (SAMC21J)
/* SERCOM0 */
#define SERCOM0_PAD0_DEFAULT      PINMUX_PA04D_SERCOM0_PAD0
#define SERCOM0_PAD1_DEFAULT      PINMUX_PA05D_SERCOM0_PAD1
#define SERCOM0_PAD2_DEFAULT      PINMUX_PA06D_SERCOM0_PAD2
#define SERCOM0_PAD3_DEFAULT      PINMUX_PA07D_SERCOM0_PAD3

/* SERCOM1 */
#define SERCOM1_PAD0_DEFAULT      PINMUX_PA16C_SERCOM1_PAD0
#define SERCOM1_PAD1_DEFAULT      PINMUX_PA17C_SERCOM1_PAD1
#define SERCOM1_PAD2_DEFAULT      PINMUX_PA18C_SERCOM1_PAD2
#define SERCOM1_PAD3_DEFAULT      PINMUX_PA19C_SERCOM1_PAD3

/* SERCOM2 */
#define SERCOM2_PAD0_DEFAULT      PINMUX_PA12C_SERCOM2_PAD0
#define SERCOM2_PAD1_DEFAULT      PINMUX_PA13C_SERCOM2_PAD1
#define SERCOM2_PAD2_DEFAULT      PINMUX_PA14C_SERCOM2_PAD2
#define SERCOM2_PAD3_DEFAULT      PINMUX_PA15C_SERCOM2_PAD3

/* SERCOM3 */
#define SERCOM3_PAD0_DEFAULT      PINMUX_PA22C_SERCOM3_PAD0
#define SERCOM3_PAD1_DEFAULT      PINMUX_PA23C_SERCOM3_PAD1
#define SERCOM3_PAD2_DEFAULT      PINMUX_PA24C_SERCOM3_PAD2
#define SERCOM3_PAD3_DEFAULT      PINMUX_PA25C_SERCOM3_PAD3

#ifdef ID_SERCOM4
/* SERCOM4 */
#define SERCOM4_PAD0_DEFAULT      PINMUX_PB08D_SERCOM4_PAD0
#define SERCOM4_PAD1_DEFAULT      PINMUX_PB09D_SERCOM4_PAD1
#define SERCOM4_PAD2_DEFAULT      PINMUX_PB10D_SERCOM4_PAD2
#define SERCOM4_PAD3_DEFAULT      PINMUX_PB11D_SERCOM4_PAD3
#endif

#ifdef ID_SERCOM5
/* SERCOM5 */
#define SERCOM5_PAD0_DEFAULT      PINMUX_PB02D_SERCOM5_PAD0
#define SERCOM5_PAD1_DEFAULT      PINMUX_PB03D_SERCOM5_PAD1
#define SERCOM5_PAD2_DEFAULT      PINMUX_PB00D_SERCOM5_PAD2
#define SERCOM5_PAD3_DEFAULT      PINMUX_PB01D_SERCOM5_PAD3
#endif

#else
/* SERCOM0 */
#define SERCOM0_PAD0_DEFAULT      PINMUX_PA04D_SERCOM0_PAD0
#define SERCOM0_PAD1_DEFAULT      PINMUX_PA05D_SERCOM0_PAD1
#define SERCOM0_PAD2_DEFAULT      PINMUX_PA06D_SERCOM0_PAD2
#define SERCOM0_PAD3_DEFAULT      PINMUX_PA07D_SERCOM0_PAD3

/* SERCOM1 */
#define SERCOM1_PAD0_DEFAULT      PINMUX_PA00D_SERCOM1_PAD0
#define SERCOM1_PAD1_DEFAULT      PINMUX_PA01D_SERCOM1_PAD1
#define SERCOM1_PAD2_DEFAULT      PINMUX_PA30D_SERCOM1_PAD2
#define SERCOM1_PAD3_DEFAULT      PINMUX_PA31D_SERCOM1_PAD3

/* SERCOM2 */
#define SERCOM2_PAD0_DEFAULT      PINMUX_PA08D_SERCOM2_PAD0
#define SERCOM2_PAD1_DEFAULT      PINMUX_PA09D_SERCOM2_PAD1
#define SERCOM2_PAD2_DEFAULT      PINMUX_PA10D_SERCOM2_PAD2
#define SERCOM2_PAD3_DEFAULT      PINMUX_PA11D_SERCOM2_PAD3

/* SERCOM3 */
#define SERCOM3_PAD0_DEFAULT      PINMUX_PA16D_SERCOM3_PAD0
#define SERCOM3_PAD1_DEFAULT      PINMUX_PA17D_SERCOM3_PAD1
#define SERCOM3_PAD2_DEFAULT      PINMUX_PA18D_SERCOM3_PAD2
#define SERCOM3_PAD3_DEFAULT      PINMUX_PA19D_SERCOM3_PAD3

/* SERCOM4 */
#define SERCOM4_PAD0_DEFAULT      PINMUX_PA12D_SERCOM4_PAD0
#define SERCOM4_PAD1_DEFAULT      PINMUX_PA13D_SERCOM4_PAD1
#define SERCOM4_PAD2_DEFAULT      PINMUX_PA14D_SERCOM4_PAD2
#define SERCOM4_PAD3_DEFAULT      PINMUX_PA15D_SERCOM4_PAD3

/* SERCOM5 */
#define SERCOM5_PAD0_DEFAULT      PINMUX_PA22D_SERCOM5_PAD0
#define SERCOM5_PAD1_DEFAULT      PINMUX_PA23D_SERCOM5_PAD1
#define SERCOM5_PAD2_DEFAULT      PINMUX_PA24D_SERCOM5_PAD2
#define SERCOM5_PAD3_DEFAULT      PINMUX_PA25D_SERCOM5_PAD3
#endif

#endif /* SERCOM_PINOUT_H_INCLUDED */

