/*******************************************************************************
 * Copyright (C) 2016 Maxim Integrated Products, Inc., All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL MAXIM INTEGRATED BE LIABLE FOR ANY CLAIM, DAMAGES
 * OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 *
 * Except as contained in this notice, the name of Maxim Integrated
 * Products, Inc. shall not be used except as stated in the Maxim Integrated
 * Products, Inc. Branding Policy.
 *
 * The mere transfer of this software does not imply any licenses
 * of trade secrets, proprietary technology, copyrights, patents,
 * trademarks, maskwork rights, or any other form of intellectual
 * property whatsoever. Maxim Integrated Products, Inc. retains all
 * ownership rights.
 ******************************************************************************/

#ifndef _MXC_PT_REGS_H_
#define _MXC_PT_REGS_H_

#ifdef __cplusplus
extern "C" {
#endif

#include <stdint.h>
#include "mxc_device.h"

/*
    If types are not defined elsewhere (CMSIS) define them here
*/
#ifndef __IO
#define __IO volatile
#endif
#ifndef __I
#define __I  volatile const
#endif
#ifndef __O
#define __O  volatile
#endif


/*
   Typedefed structure(s) for module registers (per instance or section) with direct 32-bit
   access to each register in module.
*/

/*                                                          Offset          Register Description
                                                            =============   ============================================================================ */
typedef struct {
    __IO uint32_t enable;                               /*  0x0000          Global Enable/Disable Controls for All Pulse Trains                          */
    __IO uint32_t resync;                               /*  0x0004          Global Resync (All Pulse Trains) Control                                     */
    __IO uint32_t intfl;                                /*  0x0008          Pulse Train Interrupt Flags                                                  */
    __IO uint32_t inten;                                /*  0x000C          Pulse Train Interrupt Enable/Disable                                         */
} mxc_ptg_regs_t;


/*                                                          Offset          Register Description
                                                            =============   ============================================================================ */
typedef struct {
    __IO uint32_t rate_length;                          /*  0x0000          Pulse Train Configuration                                                    */
    __IO uint32_t train;                                /*  0x0004          Pulse Train Output Pattern                                                   */
    __IO uint32_t loop;                                 /*  0x0008          Pulse Train Loop Configuration                                               */
    __IO uint32_t restart;                              /*  0x000C          Pulse Train Auto-Restart Configuration                                       */
} mxc_pt_regs_t;


/*
   Register offsets for module PT.
*/

#define MXC_R_PTG_OFFS_ENABLE                               ((uint32_t)0x00000000UL)
#define MXC_R_PTG_OFFS_RESYNC                               ((uint32_t)0x00000004UL)
#define MXC_R_PTG_OFFS_INTFL                                ((uint32_t)0x00000008UL)
#define MXC_R_PTG_OFFS_INTEN                                ((uint32_t)0x0000000CUL)
#define MXC_R_PT_OFFS_RATE_LENGTH                           ((uint32_t)0x00000000UL)
#define MXC_R_PT_OFFS_TRAIN                                 ((uint32_t)0x00000004UL)
#define MXC_R_PT_OFFS_LOOP                                  ((uint32_t)0x00000008UL)
#define MXC_R_PT_OFFS_RESTART                               ((uint32_t)0x0000000CUL)


/*
   Field positions and masks for module PT.
*/

#define MXC_F_PT_ENABLE_PT0_POS                             0
#define MXC_F_PT_ENABLE_PT0                                 ((uint32_t)(0x00000001UL << MXC_F_PT_ENABLE_PT0_POS))
#define MXC_F_PT_ENABLE_PT1_POS                             1
#define MXC_F_PT_ENABLE_PT1                                 ((uint32_t)(0x00000001UL << MXC_F_PT_ENABLE_PT1_POS))
#define MXC_F_PT_ENABLE_PT2_POS                             2
#define MXC_F_PT_ENABLE_PT2                                 ((uint32_t)(0x00000001UL << MXC_F_PT_ENABLE_PT2_POS))
#define MXC_F_PT_ENABLE_PT3_POS                             3
#define MXC_F_PT_ENABLE_PT3                                 ((uint32_t)(0x00000001UL << MXC_F_PT_ENABLE_PT3_POS))
#define MXC_F_PT_ENABLE_PT4_POS                             4
#define MXC_F_PT_ENABLE_PT4                                 ((uint32_t)(0x00000001UL << MXC_F_PT_ENABLE_PT4_POS))
#define MXC_F_PT_ENABLE_PT5_POS                             5
#define MXC_F_PT_ENABLE_PT5                                 ((uint32_t)(0x00000001UL << MXC_F_PT_ENABLE_PT5_POS))
#define MXC_F_PT_ENABLE_PT6_POS                             6
#define MXC_F_PT_ENABLE_PT6                                 ((uint32_t)(0x00000001UL << MXC_F_PT_ENABLE_PT6_POS))
#define MXC_F_PT_ENABLE_PT7_POS                             7
#define MXC_F_PT_ENABLE_PT7                                 ((uint32_t)(0x00000001UL << MXC_F_PT_ENABLE_PT7_POS))
#define MXC_F_PT_ENABLE_PT8_POS                             8
#define MXC_F_PT_ENABLE_PT8                                 ((uint32_t)(0x00000001UL << MXC_F_PT_ENABLE_PT8_POS))
#define MXC_F_PT_ENABLE_PT9_POS                             9
#define MXC_F_PT_ENABLE_PT9                                 ((uint32_t)(0x00000001UL << MXC_F_PT_ENABLE_PT9_POS))
#define MXC_F_PT_ENABLE_PT10_POS                            10
#define MXC_F_PT_ENABLE_PT10                                ((uint32_t)(0x00000001UL << MXC_F_PT_ENABLE_PT10_POS))
#define MXC_F_PT_ENABLE_PT11_POS                            11
#define MXC_F_PT_ENABLE_PT11                                ((uint32_t)(0x00000001UL << MXC_F_PT_ENABLE_PT11_POS))
#define MXC_F_PT_ENABLE_PT12_POS                            12
#define MXC_F_PT_ENABLE_PT12                                ((uint32_t)(0x00000001UL << MXC_F_PT_ENABLE_PT12_POS))
#define MXC_F_PT_ENABLE_PT13_POS                            13
#define MXC_F_PT_ENABLE_PT13                                ((uint32_t)(0x00000001UL << MXC_F_PT_ENABLE_PT13_POS))
#define MXC_F_PT_ENABLE_PT14_POS                            14
#define MXC_F_PT_ENABLE_PT14                                ((uint32_t)(0x00000001UL << MXC_F_PT_ENABLE_PT14_POS))
#define MXC_F_PT_ENABLE_PT15_POS                            15
#define MXC_F_PT_ENABLE_PT15                                ((uint32_t)(0x00000001UL << MXC_F_PT_ENABLE_PT15_POS))

#define MXC_F_PT_RESYNC_PT0_POS                             0
#define MXC_F_PT_RESYNC_PT0                                 ((uint32_t)(0x00000001UL << MXC_F_PT_RESYNC_PT0_POS))
#define MXC_F_PT_RESYNC_PT1_POS                             1
#define MXC_F_PT_RESYNC_PT1                                 ((uint32_t)(0x00000001UL << MXC_F_PT_RESYNC_PT1_POS))
#define MXC_F_PT_RESYNC_PT2_POS                             2
#define MXC_F_PT_RESYNC_PT2                                 ((uint32_t)(0x00000001UL << MXC_F_PT_RESYNC_PT2_POS))
#define MXC_F_PT_RESYNC_PT3_POS                             3
#define MXC_F_PT_RESYNC_PT3                                 ((uint32_t)(0x00000001UL << MXC_F_PT_RESYNC_PT3_POS))
#define MXC_F_PT_RESYNC_PT4_POS                             4
#define MXC_F_PT_RESYNC_PT4                                 ((uint32_t)(0x00000001UL << MXC_F_PT_RESYNC_PT4_POS))
#define MXC_F_PT_RESYNC_PT5_POS                             5
#define MXC_F_PT_RESYNC_PT5                                 ((uint32_t)(0x00000001UL << MXC_F_PT_RESYNC_PT5_POS))
#define MXC_F_PT_RESYNC_PT6_POS                             6
#define MXC_F_PT_RESYNC_PT6                                 ((uint32_t)(0x00000001UL << MXC_F_PT_RESYNC_PT6_POS))
#define MXC_F_PT_RESYNC_PT7_POS                             7
#define MXC_F_PT_RESYNC_PT7                                 ((uint32_t)(0x00000001UL << MXC_F_PT_RESYNC_PT7_POS))
#define MXC_F_PT_RESYNC_PT8_POS                             8
#define MXC_F_PT_RESYNC_PT8                                 ((uint32_t)(0x00000001UL << MXC_F_PT_RESYNC_PT8_POS))
#define MXC_F_PT_RESYNC_PT9_POS                             9
#define MXC_F_PT_RESYNC_PT9                                 ((uint32_t)(0x00000001UL << MXC_F_PT_RESYNC_PT9_POS))
#define MXC_F_PT_RESYNC_PT10_POS                            10
#define MXC_F_PT_RESYNC_PT10                                ((uint32_t)(0x00000001UL << MXC_F_PT_RESYNC_PT10_POS))
#define MXC_F_PT_RESYNC_PT11_POS                            11
#define MXC_F_PT_RESYNC_PT11                                ((uint32_t)(0x00000001UL << MXC_F_PT_RESYNC_PT11_POS))
#define MXC_F_PT_RESYNC_PT12_POS                            12
#define MXC_F_PT_RESYNC_PT12                                ((uint32_t)(0x00000001UL << MXC_F_PT_RESYNC_PT12_POS))
#define MXC_F_PT_RESYNC_PT13_POS                            13
#define MXC_F_PT_RESYNC_PT13                                ((uint32_t)(0x00000001UL << MXC_F_PT_RESYNC_PT13_POS))
#define MXC_F_PT_RESYNC_PT14_POS                            14
#define MXC_F_PT_RESYNC_PT14                                ((uint32_t)(0x00000001UL << MXC_F_PT_RESYNC_PT14_POS))
#define MXC_F_PT_RESYNC_PT15_POS                            15
#define MXC_F_PT_RESYNC_PT15                                ((uint32_t)(0x00000001UL << MXC_F_PT_RESYNC_PT15_POS))

#define MXC_F_PT_INTFL_PT0_POS                              0
#define MXC_F_PT_INTFL_PT0                                  ((uint32_t)(0x00000001UL << MXC_F_PT_INTFL_PT0_POS))
#define MXC_F_PT_INTFL_PT1_POS                              1
#define MXC_F_PT_INTFL_PT1                                  ((uint32_t)(0x00000001UL << MXC_F_PT_INTFL_PT1_POS))
#define MXC_F_PT_INTFL_PT2_POS                              2
#define MXC_F_PT_INTFL_PT2                                  ((uint32_t)(0x00000001UL << MXC_F_PT_INTFL_PT2_POS))
#define MXC_F_PT_INTFL_PT3_POS                              3
#define MXC_F_PT_INTFL_PT3                                  ((uint32_t)(0x00000001UL << MXC_F_PT_INTFL_PT3_POS))
#define MXC_F_PT_INTFL_PT4_POS                              4
#define MXC_F_PT_INTFL_PT4                                  ((uint32_t)(0x00000001UL << MXC_F_PT_INTFL_PT4_POS))
#define MXC_F_PT_INTFL_PT5_POS                              5
#define MXC_F_PT_INTFL_PT5                                  ((uint32_t)(0x00000001UL << MXC_F_PT_INTFL_PT5_POS))
#define MXC_F_PT_INTFL_PT6_POS                              6
#define MXC_F_PT_INTFL_PT6                                  ((uint32_t)(0x00000001UL << MXC_F_PT_INTFL_PT6_POS))
#define MXC_F_PT_INTFL_PT7_POS                              7
#define MXC_F_PT_INTFL_PT7                                  ((uint32_t)(0x00000001UL << MXC_F_PT_INTFL_PT7_POS))
#define MXC_F_PT_INTFL_PT8_POS                              8
#define MXC_F_PT_INTFL_PT8                                  ((uint32_t)(0x00000001UL << MXC_F_PT_INTFL_PT8_POS))
#define MXC_F_PT_INTFL_PT9_POS                              9
#define MXC_F_PT_INTFL_PT9                                  ((uint32_t)(0x00000001UL << MXC_F_PT_INTFL_PT9_POS))
#define MXC_F_PT_INTFL_PT10_POS                             10
#define MXC_F_PT_INTFL_PT10                                 ((uint32_t)(0x00000001UL << MXC_F_PT_INTFL_PT10_POS))
#define MXC_F_PT_INTFL_PT11_POS                             11
#define MXC_F_PT_INTFL_PT11                                 ((uint32_t)(0x00000001UL << MXC_F_PT_INTFL_PT11_POS))
#define MXC_F_PT_INTFL_PT12_POS                             12
#define MXC_F_PT_INTFL_PT12                                 ((uint32_t)(0x00000001UL << MXC_F_PT_INTFL_PT12_POS))
#define MXC_F_PT_INTFL_PT13_POS                             13
#define MXC_F_PT_INTFL_PT13                                 ((uint32_t)(0x00000001UL << MXC_F_PT_INTFL_PT13_POS))
#define MXC_F_PT_INTFL_PT14_POS                             14
#define MXC_F_PT_INTFL_PT14                                 ((uint32_t)(0x00000001UL << MXC_F_PT_INTFL_PT14_POS))
#define MXC_F_PT_INTFL_PT15_POS                             15
#define MXC_F_PT_INTFL_PT15                                 ((uint32_t)(0x00000001UL << MXC_F_PT_INTFL_PT15_POS))

#define MXC_F_PT_INTEN_PT0_POS                              0
#define MXC_F_PT_INTEN_PT0                                  ((uint32_t)(0x00000001UL << MXC_F_PT_INTEN_PT0_POS))
#define MXC_F_PT_INTEN_PT1_POS                              1
#define MXC_F_PT_INTEN_PT1                                  ((uint32_t)(0x00000001UL << MXC_F_PT_INTEN_PT1_POS))
#define MXC_F_PT_INTEN_PT2_POS                              2
#define MXC_F_PT_INTEN_PT2                                  ((uint32_t)(0x00000001UL << MXC_F_PT_INTEN_PT2_POS))
#define MXC_F_PT_INTEN_PT3_POS                              3
#define MXC_F_PT_INTEN_PT3                                  ((uint32_t)(0x00000001UL << MXC_F_PT_INTEN_PT3_POS))
#define MXC_F_PT_INTEN_PT4_POS                              4
#define MXC_F_PT_INTEN_PT4                                  ((uint32_t)(0x00000001UL << MXC_F_PT_INTEN_PT4_POS))
#define MXC_F_PT_INTEN_PT5_POS                              5
#define MXC_F_PT_INTEN_PT5                                  ((uint32_t)(0x00000001UL << MXC_F_PT_INTEN_PT5_POS))
#define MXC_F_PT_INTEN_PT6_POS                              6
#define MXC_F_PT_INTEN_PT6                                  ((uint32_t)(0x00000001UL << MXC_F_PT_INTEN_PT6_POS))
#define MXC_F_PT_INTEN_PT7_POS                              7
#define MXC_F_PT_INTEN_PT7                                  ((uint32_t)(0x00000001UL << MXC_F_PT_INTEN_PT7_POS))
#define MXC_F_PT_INTEN_PT8_POS                              8
#define MXC_F_PT_INTEN_PT8                                  ((uint32_t)(0x00000001UL << MXC_F_PT_INTEN_PT8_POS))
#define MXC_F_PT_INTEN_PT9_POS                              9
#define MXC_F_PT_INTEN_PT9                                  ((uint32_t)(0x00000001UL << MXC_F_PT_INTEN_PT9_POS))
#define MXC_F_PT_INTEN_PT10_POS                             10
#define MXC_F_PT_INTEN_PT10                                 ((uint32_t)(0x00000001UL << MXC_F_PT_INTEN_PT10_POS))
#define MXC_F_PT_INTEN_PT11_POS                             11
#define MXC_F_PT_INTEN_PT11                                 ((uint32_t)(0x00000001UL << MXC_F_PT_INTEN_PT11_POS))
#define MXC_F_PT_INTEN_PT12_POS                             12
#define MXC_F_PT_INTEN_PT12                                 ((uint32_t)(0x00000001UL << MXC_F_PT_INTEN_PT12_POS))
#define MXC_F_PT_INTEN_PT13_POS                             13
#define MXC_F_PT_INTEN_PT13                                 ((uint32_t)(0x00000001UL << MXC_F_PT_INTEN_PT13_POS))
#define MXC_F_PT_INTEN_PT14_POS                             14
#define MXC_F_PT_INTEN_PT14                                 ((uint32_t)(0x00000001UL << MXC_F_PT_INTEN_PT14_POS))
#define MXC_F_PT_INTEN_PT15_POS                             15
#define MXC_F_PT_INTEN_PT15                                 ((uint32_t)(0x00000001UL << MXC_F_PT_INTEN_PT15_POS))

#define MXC_F_PT_RATE_LENGTH_RATE_CONTROL_POS               0
#define MXC_F_PT_RATE_LENGTH_RATE_CONTROL                   ((uint32_t)(0x07FFFFFFUL << MXC_F_PT_RATE_LENGTH_RATE_CONTROL_POS))
#define MXC_F_PT_RATE_LENGTH_MODE_POS                       27
#define MXC_F_PT_RATE_LENGTH_MODE                           ((uint32_t)(0x0000001FUL << MXC_F_PT_RATE_LENGTH_MODE_POS))

#define MXC_F_PT_LOOP_COUNT_POS                             0
#define MXC_F_PT_LOOP_COUNT                                 ((uint32_t)(0x0000FFFFUL << MXC_F_PT_LOOP_COUNT_POS))
#define MXC_F_PT_LOOP_DELAY_POS                             16
#define MXC_F_PT_LOOP_DELAY                                 ((uint32_t)(0x00000FFFUL << MXC_F_PT_LOOP_DELAY_POS))

#define MXC_F_PT_RESTART_PT_X_SELECT_POS                    0
#define MXC_F_PT_RESTART_PT_X_SELECT                        ((uint32_t)(0x0000001FUL << MXC_F_PT_RESTART_PT_X_SELECT_POS))
#define MXC_F_PT_RESTART_ON_PT_X_LOOP_EXIT_POS              7
#define MXC_F_PT_RESTART_ON_PT_X_LOOP_EXIT                  ((uint32_t)(0x00000001UL << MXC_F_PT_RESTART_ON_PT_X_LOOP_EXIT_POS))
#define MXC_F_PT_RESTART_PT_Y_SELECT_POS                    8
#define MXC_F_PT_RESTART_PT_Y_SELECT                        ((uint32_t)(0x0000001FUL << MXC_F_PT_RESTART_PT_Y_SELECT_POS))
#define MXC_F_PT_RESTART_ON_PT_Y_LOOP_EXIT_POS              15
#define MXC_F_PT_RESTART_ON_PT_Y_LOOP_EXIT                  ((uint32_t)(0x00000001UL << MXC_F_PT_RESTART_ON_PT_Y_LOOP_EXIT_POS))



/*
   Field values and shifted values for module PT.
*/

#define MXC_V_PT_RATE_LENGTH_MODE_32_BIT                                        ((uint32_t)(0x00000000UL))
#define MXC_V_PT_RATE_LENGTH_MODE_SQUARE_WAVE                                   ((uint32_t)(0x00000001UL))
#define MXC_V_PT_RATE_LENGTH_MODE_2_BIT                                         ((uint32_t)(0x00000002UL))
#define MXC_V_PT_RATE_LENGTH_MODE_3_BIT                                         ((uint32_t)(0x00000003UL))
#define MXC_V_PT_RATE_LENGTH_MODE_4_BIT                                         ((uint32_t)(0x00000004UL))
#define MXC_V_PT_RATE_LENGTH_MODE_5_BIT                                         ((uint32_t)(0x00000005UL))
#define MXC_V_PT_RATE_LENGTH_MODE_6_BIT                                         ((uint32_t)(0x00000006UL))
#define MXC_V_PT_RATE_LENGTH_MODE_7_BIT                                         ((uint32_t)(0x00000007UL))
#define MXC_V_PT_RATE_LENGTH_MODE_8_BIT                                         ((uint32_t)(0x00000008UL))
#define MXC_V_PT_RATE_LENGTH_MODE_9_BIT                                         ((uint32_t)(0x00000009UL))
#define MXC_V_PT_RATE_LENGTH_MODE_10_BIT                                        ((uint32_t)(0x0000000AUL))
#define MXC_V_PT_RATE_LENGTH_MODE_11_BIT                                        ((uint32_t)(0x0000000BUL))
#define MXC_V_PT_RATE_LENGTH_MODE_12_BIT                                        ((uint32_t)(0x0000000CUL))
#define MXC_V_PT_RATE_LENGTH_MODE_13_BIT                                        ((uint32_t)(0x0000000DUL))
#define MXC_V_PT_RATE_LENGTH_MODE_14_BIT                                        ((uint32_t)(0x0000000EUL))
#define MXC_V_PT_RATE_LENGTH_MODE_15_BIT                                        ((uint32_t)(0x0000000FUL))
#define MXC_V_PT_RATE_LENGTH_MODE_16_BIT                                        ((uint32_t)(0x00000010UL))
#define MXC_V_PT_RATE_LENGTH_MODE_17_BIT                                        ((uint32_t)(0x00000011UL))
#define MXC_V_PT_RATE_LENGTH_MODE_18_BIT                                        ((uint32_t)(0x00000012UL))
#define MXC_V_PT_RATE_LENGTH_MODE_19_BIT                                        ((uint32_t)(0x00000013UL))
#define MXC_V_PT_RATE_LENGTH_MODE_20_BIT                                        ((uint32_t)(0x00000014UL))
#define MXC_V_PT_RATE_LENGTH_MODE_21_BIT                                        ((uint32_t)(0x00000015UL))
#define MXC_V_PT_RATE_LENGTH_MODE_22_BIT                                        ((uint32_t)(0x00000016UL))
#define MXC_V_PT_RATE_LENGTH_MODE_23_BIT                                        ((uint32_t)(0x00000017UL))
#define MXC_V_PT_RATE_LENGTH_MODE_24_BIT                                        ((uint32_t)(0x00000018UL))
#define MXC_V_PT_RATE_LENGTH_MODE_25_BIT                                        ((uint32_t)(0x00000019UL))
#define MXC_V_PT_RATE_LENGTH_MODE_26_BIT                                        ((uint32_t)(0x0000001AUL))
#define MXC_V_PT_RATE_LENGTH_MODE_27_BIT                                        ((uint32_t)(0x0000001BUL))
#define MXC_V_PT_RATE_LENGTH_MODE_28_BIT                                        ((uint32_t)(0x0000001CUL))
#define MXC_V_PT_RATE_LENGTH_MODE_29_BIT                                        ((uint32_t)(0x0000001DUL))
#define MXC_V_PT_RATE_LENGTH_MODE_30_BIT                                        ((uint32_t)(0x0000001EUL))
#define MXC_V_PT_RATE_LENGTH_MODE_31_BIT                                        ((uint32_t)(0x0000001FUL))

#define MXC_S_PT_RATE_LENGTH_MODE_32_BIT                                        ((uint32_t)(MXC_V_PT_RATE_LENGTH_MODE_32_BIT       << MXC_F_PT_RATE_LENGTH_MODE_POS))
#define MXC_S_PT_RATE_LENGTH_MODE_SQUARE_WAVE                                   ((uint32_t)(MXC_V_PT_RATE_LENGTH_MODE_SQUARE_WAVE  << MXC_F_PT_RATE_LENGTH_MODE_POS))
#define MXC_S_PT_RATE_LENGTH_MODE_2_BIT                                         ((uint32_t)(MXC_V_PT_RATE_LENGTH_MODE_2_BIT        << MXC_F_PT_RATE_LENGTH_MODE_POS))
#define MXC_S_PT_RATE_LENGTH_MODE_3_BIT                                         ((uint32_t)(MXC_V_PT_RATE_LENGTH_MODE_3_BIT        << MXC_F_PT_RATE_LENGTH_MODE_POS))
#define MXC_S_PT_RATE_LENGTH_MODE_4_BIT                                         ((uint32_t)(MXC_V_PT_RATE_LENGTH_MODE_4_BIT        << MXC_F_PT_RATE_LENGTH_MODE_POS))
#define MXC_S_PT_RATE_LENGTH_MODE_5_BIT                                         ((uint32_t)(MXC_V_PT_RATE_LENGTH_MODE_5_BIT        << MXC_F_PT_RATE_LENGTH_MODE_POS))
#define MXC_S_PT_RATE_LENGTH_MODE_6_BIT                                         ((uint32_t)(MXC_V_PT_RATE_LENGTH_MODE_6_BIT        << MXC_F_PT_RATE_LENGTH_MODE_POS))
#define MXC_S_PT_RATE_LENGTH_MODE_7_BIT                                         ((uint32_t)(MXC_V_PT_RATE_LENGTH_MODE_7_BIT        << MXC_F_PT_RATE_LENGTH_MODE_POS))
#define MXC_S_PT_RATE_LENGTH_MODE_8_BIT                                         ((uint32_t)(MXC_V_PT_RATE_LENGTH_MODE_8_BIT        << MXC_F_PT_RATE_LENGTH_MODE_POS))
#define MXC_S_PT_RATE_LENGTH_MODE_9_BIT                                         ((uint32_t)(MXC_V_PT_RATE_LENGTH_MODE_9_BIT        << MXC_F_PT_RATE_LENGTH_MODE_POS))
#define MXC_S_PT_RATE_LENGTH_MODE_10_BIT                                        ((uint32_t)(MXC_V_PT_RATE_LENGTH_MODE_10_BIT       << MXC_F_PT_RATE_LENGTH_MODE_POS))
#define MXC_S_PT_RATE_LENGTH_MODE_11_BIT                                        ((uint32_t)(MXC_V_PT_RATE_LENGTH_MODE_11_BIT       << MXC_F_PT_RATE_LENGTH_MODE_POS))
#define MXC_S_PT_RATE_LENGTH_MODE_12_BIT                                        ((uint32_t)(MXC_V_PT_RATE_LENGTH_MODE_12_BIT       << MXC_F_PT_RATE_LENGTH_MODE_POS))
#define MXC_S_PT_RATE_LENGTH_MODE_13_BIT                                        ((uint32_t)(MXC_V_PT_RATE_LENGTH_MODE_13_BIT       << MXC_F_PT_RATE_LENGTH_MODE_POS))
#define MXC_S_PT_RATE_LENGTH_MODE_14_BIT                                        ((uint32_t)(MXC_V_PT_RATE_LENGTH_MODE_14_BIT       << MXC_F_PT_RATE_LENGTH_MODE_POS))
#define MXC_S_PT_RATE_LENGTH_MODE_15_BIT                                        ((uint32_t)(MXC_V_PT_RATE_LENGTH_MODE_15_BIT       << MXC_F_PT_RATE_LENGTH_MODE_POS))
#define MXC_S_PT_RATE_LENGTH_MODE_16_BIT                                        ((uint32_t)(MXC_V_PT_RATE_LENGTH_MODE_16_BIT       << MXC_F_PT_RATE_LENGTH_MODE_POS))
#define MXC_S_PT_RATE_LENGTH_MODE_17_BIT                                        ((uint32_t)(MXC_V_PT_RATE_LENGTH_MODE_17_BIT       << MXC_F_PT_RATE_LENGTH_MODE_POS))
#define MXC_S_PT_RATE_LENGTH_MODE_18_BIT                                        ((uint32_t)(MXC_V_PT_RATE_LENGTH_MODE_18_BIT       << MXC_F_PT_RATE_LENGTH_MODE_POS))
#define MXC_S_PT_RATE_LENGTH_MODE_19_BIT                                        ((uint32_t)(MXC_V_PT_RATE_LENGTH_MODE_19_BIT       << MXC_F_PT_RATE_LENGTH_MODE_POS))
#define MXC_S_PT_RATE_LENGTH_MODE_20_BIT                                        ((uint32_t)(MXC_V_PT_RATE_LENGTH_MODE_20_BIT       << MXC_F_PT_RATE_LENGTH_MODE_POS))
#define MXC_S_PT_RATE_LENGTH_MODE_21_BIT                                        ((uint32_t)(MXC_V_PT_RATE_LENGTH_MODE_21_BIT       << MXC_F_PT_RATE_LENGTH_MODE_POS))
#define MXC_S_PT_RATE_LENGTH_MODE_22_BIT                                        ((uint32_t)(MXC_V_PT_RATE_LENGTH_MODE_22_BIT       << MXC_F_PT_RATE_LENGTH_MODE_POS))
#define MXC_S_PT_RATE_LENGTH_MODE_23_BIT                                        ((uint32_t)(MXC_V_PT_RATE_LENGTH_MODE_23_BIT       << MXC_F_PT_RATE_LENGTH_MODE_POS))
#define MXC_S_PT_RATE_LENGTH_MODE_24_BIT                                        ((uint32_t)(MXC_V_PT_RATE_LENGTH_MODE_24_BIT       << MXC_F_PT_RATE_LENGTH_MODE_POS))
#define MXC_S_PT_RATE_LENGTH_MODE_25_BIT                                        ((uint32_t)(MXC_V_PT_RATE_LENGTH_MODE_25_BIT       << MXC_F_PT_RATE_LENGTH_MODE_POS))
#define MXC_S_PT_RATE_LENGTH_MODE_26_BIT                                        ((uint32_t)(MXC_V_PT_RATE_LENGTH_MODE_26_BIT       << MXC_F_PT_RATE_LENGTH_MODE_POS))
#define MXC_S_PT_RATE_LENGTH_MODE_27_BIT                                        ((uint32_t)(MXC_V_PT_RATE_LENGTH_MODE_27_BIT       << MXC_F_PT_RATE_LENGTH_MODE_POS))
#define MXC_S_PT_RATE_LENGTH_MODE_28_BIT                                        ((uint32_t)(MXC_V_PT_RATE_LENGTH_MODE_28_BIT       << MXC_F_PT_RATE_LENGTH_MODE_POS))
#define MXC_S_PT_RATE_LENGTH_MODE_29_BIT                                        ((uint32_t)(MXC_V_PT_RATE_LENGTH_MODE_29_BIT       << MXC_F_PT_RATE_LENGTH_MODE_POS))
#define MXC_S_PT_RATE_LENGTH_MODE_30_BIT                                        ((uint32_t)(MXC_V_PT_RATE_LENGTH_MODE_30_BIT       << MXC_F_PT_RATE_LENGTH_MODE_POS))
#define MXC_S_PT_RATE_LENGTH_MODE_31_BIT                                        ((uint32_t)(MXC_V_PT_RATE_LENGTH_MODE_31_BIT       << MXC_F_PT_RATE_LENGTH_MODE_POS))



#ifdef __cplusplus
}
#endif

#endif   /* _MXC_PT_REGS_H_ */


