#ifndef MBED_GEIGERCOUNTER_H
#define MBED_GEIGERCOUNTER_H
#include "mbed.h"

class Geigercounter {
public:
    Geigercounter(PinName pin,PinName spin) : _interrupt(pin),_speaker(spin),_speakerstop(){        
        _interrupt.rise(this, &Geigercounter::increment); 
        
        //speaker setup sound off
        _speaker.period(1.0/2000.0);
        _speaker=0.0;
        _speakeron=true;
    }

    void start(){
      _count=0;
      _starttime=time(NULL);
      _geigerrun=true;
    }
    
    void stop(){
      _geigerrun=false;
      _stoptime=time(NULL);
      
    }
    
    void soundon(){
      _speakeron=true;
    }
    
    void soundoff(){
     _speakeron=false;
    }
     
    
    float getcps();
    float getcpm();    
    
    int read() {
        return _count;
    }

private:
    void _speakeroff(){
      _speaker=0;
    }
    void increment() {
      if(_geigerrun){
      
        _count++;
        
        //sound
        if(_speakeron){
          _speaker=0.5;
          _speakerstop.attach(this,&Geigercounter::_speakeroff,0.02);
        }
      }
    }

    InterruptIn _interrupt;
    PwmOut _speaker;
    Timeout _speakerstop;
    time_t       _starttime;
    time_t       _stoptime;
    volatile int _count;
    volatile bool _geigerrun;
    volatile bool _speakeron;

};


#endif