#include "mbed.h"
#include "geigercounter_sbm_20.h"
#include "trans.h"
#include "TextLCD.h"


#include "mbed.h"
#include "PachubeV2CSV.h"
#include "EthernetNetIf.h"
#include "HTTPClient.h"
#include "appconf.h"
#include "FirmwareUpdater.h"



 extern "C" void mbed_reset();
 
/*
 * Definitions for a configuration file.
 */
#define CONFIG_FILENAME "/local/PACHUBE.CFG"
const int PACHUBE_CODE_OK = 200;

LocalFileSystem localfs("local");

EthernetNetIf netif;

FirmwareUpdater fwup("http://mbed.org/media/uploads/abe00makoto", "geiger", true);

TextLCD  output( p24, p26, p27, p28, p29, p30 ); // rs, e, d0-d3
Geigercounter_SBM_20 geiger(p18,p22);//Geiger pin,Spekaer pin
Trans trans(p21,0.16/1000.0,0.68/*0.76*/); //Trans pin,period,duty

static appconf_t appconf;


/**
 * Convert double to char.
 *
 * @param val Value.
 * @param buf A pointer to a buffer.
 * @param bufsiz The buffer size.
 */
void convertDoubleToChar(double val, char *buf, size_t bufsiz) {
    snprintf(buf, bufsiz, "%f", val);
}

/**
 * Post to the feed on Pachube.
 *
 * @param web Pointer to a Pachube object.
 * @param feed_id Feed ID.
 * @param stream_no Stream number.
 * @param value value.
 *
 * @return Pachube code.
 */
int web_post(PachubeV2CSV *web, int feed_id, int stream_no, double value) {
    char value_text[16];
    convertDoubleToChar(value, value_text, sizeof(value_text));
    char stream_no_text[8];
    stream_no_text[0] = "0123456789"[stream_no];
    stream_no_text[1] = '\0';
    return web->updateDataStream(feed_id, stream_no_text, std::string(value_text));
}



//firm ware updater
void check_newfirm() {
    if (fwup.exist() == 0) {
        output.printf("Found a new firmware.\n");
        if (fwup.execute() == 0) {
            output.printf("Update succeed.\n");
            wait(10);
            output.printf("Resetting this system.\n");
            wait(10);
            fwup.reset();
        } else {
            output.printf("Update failed!\n");
            
        }
    }else{
       output.printf("not found update.\n");
    }
    wait(5);
}

void print_geigerdata()
{
    output.cls();
    output.printf("%.3fuSv/h\n",geiger.getusv());
    output.printf("%.3fCPM",geiger.getcpm());
}




int main() {
  
  bool etherconnect;
  output.cls();
  output.printf("Hello.");
  wait(1);
  set_time(0); //mbed first run dont use time();
  
  
  /*
   * Initialize ethernet interface.
   */
  output.cls();
  output.locate(0, 0);
  output.printf("Initializing...");
  output.locate(0, 1);
  output.printf("Ethernet: ");
  
  EthernetErr ethErr = netif.setup();
  if (ethErr) {
      output.printf("[NG]");
      //error("Ethernet setup failed. Done with code %d.\n", ethErr);
      etherconnect=false;
  }
  else{
      etherconnect=true;
      output.printf("[OK]");
  }
  
  wait(2);
  if(etherconnect){    
    //firmware update
    output.cls();
    check_newfirm();
  } 
  
    /*
     * Read configuration variables from a file.
     */
  output.cls();
  output.locate(0, 0);
  output.printf("cfg file Reading...");
  output.locate(0, 1);
  output.printf("Setup: ");
  appconf_init(&appconf);
  if (appconf_read(CONFIG_FILENAME, &appconf) != 0) {
      output.printf("[NG]");
      error("Failure to read a configuration file.\n");
  }
  else{
    output.printf("[OK]");
    wait(3);
  }
    
  /*
   * Initialize objects.
   */
  PachubeV2CSV web(appconf.apikey);
  const int feed_id = atoi(appconf.feedid);
      
  
  
  //20 minitues loop
  for(int min=0;min<(20/5);min++){
    trans.on();
    wait(0.5);
    geiger.start();  
    //5 minitues geiger run
    for(int i=0;i<5*60;i++){
      print_geigerdata();
      wait(1); 
    }
    geiger.stop();
    trans.off();
    output.cls();
    print_geigerdata();
    wait(1);
    /*
     * Check the pachube feautures.
     */
    if(etherconnect){
  
        if (web_post(&web, feed_id, 0, geiger.getusv()) != PACHUBE_CODE_OK) {
          output.cls();
          output.printf("Checking Pachube \nstatus:x");
          wait(10);
          
        }

        if (web_post(&web, feed_id, 1, geiger.getcpm()) != PACHUBE_CODE_OK){
          output.cls();
          output.printf("Checking Pachube \nstatus:x");
          wait(10);
        }
    }
  }
  
  if(!etherconnect){
    output.cls();
    output.printf("please!!\n net connect\n");
    wait(10);
    output.cls();
    output.printf("mbed reset!!\n");
    wait(10);
    mbed_reset();
  }
  
  
  //
  //  night running mode. 
  //
  output.cls();
  output.printf("sound off mode..");
  geiger.soundoff();
  
  int errcnt=0;
  while(1){
    
    for(int min=0;min<(20/5);min++){
      trans.on();
      wait(1);
      geiger.start();
      for(int i=0;i<5*60;i++){
        print_geigerdata();
        wait(1); 
      }
  
      geiger.stop();
      trans.off();
    
      /*
       * Post.
       */
      if(etherconnect){
        if (web_post(&web, feed_id, 0, geiger.getusv()) != PACHUBE_CODE_OK) {
          output.cls();
          output.printf("Checking Pachube \nstatus:x");
          errcnt++;
          wait(10);
        }

        if (web_post(&web, feed_id, 1, geiger.getcpm()) != PACHUBE_CODE_OK){
          output.cls();
          output.printf("Checking Pachube \nstatus:x");
          errcnt++;
          wait(10);
        }
      }//if(etherconncet)
    }//for
    
    //if firmware exist.reset. 
    if(etherconnect){
      if(fwup.exist()==0)mbed_reset();
    }
    
    //many error!! reset
    if(errcnt>20)mbed_reset();
  }//while
}