#include "geiger.h"
#include "Terminal.h"
#include "TextLCD.h"
#include "SDFileSystem.h"


//debug use 
//#define DEBUG

//avarage range minutes
#define AVARAGE_MIN 5

//sleeptime after a minute cout
#define SLEEP_SEC 30 

//if sdcard not use commentout #define SD_USE
#define SD_USE

#ifdef DEBUG
Terminal output(USBTX, USBRX); // tx, rx
#else
TextLCD  output( p24, p26, p27, p28, p29, p30 ); // rs, e, d0-d3
#endif

//Trans contorol pin 
#define CTL_TRANS_PIN p21

//Trans params 
#define TRANS_PERIOD (0.16/1000.0)
#define TRANS_DUTY  (0.83)

//Giger Counter Pin
#define GIGER_PIN p18

#ifdef SD_USE
//SD File system setup
SDFileSystem sd(p5, p6, p7, p8, "sd"); // mosi, miso, sclk, cs
#endif

DigitalOut waiting(LED1);
DigitalOut working(LED2);

PwmOut trans_ctl(CTL_TRANS_PIN);
InterruptIn gigerin(GIGER_PIN);
Ticker show;
//for timedata
char buf[40];
time_t sec;

//counter 
int cnt;
//array first touch index chk 
int first_touch_index;
//micro sv value
float usv;
//peak sv value;
float peak_usv;


//for avarage calculate arrays
float cpm_array[AVARAGE_MIN];
//current index for array
int cpm_index;


/////////////////////////////////
//trans contorol for 400v make //
/////////////////////////////////

//make 400v
void transon()
{
    //6khz puluse
    trans_ctl.period(TRANS_PERIOD);
    trans_ctl=TRANS_DUTY;
}

//trans sleep!
void transoff()
{
    trans_ctl=0.0;
}


//print lcd for 1sec
void show_result()
{
  output.cls();
  output.printf("NOW%fuSv/h",usv);
  output.printf("PEK%fuSv/h",peak_usv);
  
}
//sv value calc
void calculate_sv()
{
  float cpm=0;
  for(int i=0;i<=first_touch_index;i++)
  {
    cpm+=cpm_array[i];
  }
  cpm/=(first_touch_index+1);
  //si-3bg is maybe 200 cps/R/h = 200 cps/ 10000uSv/h = 0.02 cps/uSv/h  
  usv=cpm/60.0*0.02;
  
  //peak usv set
  if(peak_usv<usv)
  {
    peak_usv=usv;
  }
}


void debug_print()
{

  //printf("\r\n\r\nresult_str=%s\r\n",result_str);
 
  float cpm=0;
  for(int i=0;i<=first_touch_index;i++)
  {
    cpm+=cpm_array[i];
  }
  cpm/=(first_touch_index+1); 
  printf("%fuSv/h\r\n",cpm/20.0);
  for(int i=0;i<AVARAGE_MIN;i++)
  {
    printf("[%d]=%f\r\n",i,cpm_array[i]);
  }
  printf("first_touch_index=%d\r\n",first_touch_index);
  printf("cpm_index=%d\r\n",cpm_index);
  
  
}
//interuput giger pin
void geiger_countup()
{
  //if sleeptime countup stoped.
  if(!working)
    return;

  cnt++;
  cpm_array[cpm_index]=cnt;
  calculate_sv();
//  debug_print();
}

//geiger count after 1min
void next_geiger_countup()
{
 
  cnt=0;
  cpm_index++;
  if(cpm_index >=AVARAGE_MIN)
  {
    cpm_index=0;
  }
  
  //first touch index count up
  if(cpm_index>first_touch_index)
  {
    first_touch_index=cpm_index;
  }
  
  cpm_array[cpm_index]=cnt;
  calculate_sv();
//  debug_print();
}


void setup_pinmode()
{
  //p25 lowlevel = write mode?
  gigerin.mode(PullNone);
  gigerin.rise(&geiger_countup);
}



//geiger system init
void geiger_setup()
{
  first_touch_index=0;
  cnt=0;
  setup_pinmode();
  sec=time(NULL);
  strftime(buf,40, "%Y/%m/%d\n%X", localtime(&sec));
  //fprintf(fp, "giger start %s \n",buf);
  output.cls();
  output.printf("TIME%s",buf);
  wait(1);
  output.cls();
  output.printf("please wait....");
  //lcd show setup 1sec print
  show.attach(&show_result,1.0);
}


void geigerrun()
{


#ifdef SD_USE
//SD card write
    { 
      FILE *fp = fopen("/sd/giger.txt", "a");
      if(fp == NULL) {
         // error("Could not open file for write\n");
         printf("please insert SD");
      }
      else
      {
        sec=time(NULL);
        strftime(buf,40, "%Y/%m/%d %X", localtime(&sec));
        fprintf(fp, "giger start %s \n",buf);
        fclose(fp);
       } 
    }
#endif
  geiger_setup();
  while(1)
  {
    waiting=1;
    transon();
    //400v voltage set waiting
    wait(1);
    waiting=0;

    //
    //count up start
    //
    working=1;
    //count start
    cnt=0;
    calculate_sv();
    wait(60);
    working=0;
    waiting=1;    
    //
    // trans cooldown time
    //
    transoff();
    //next countup  move index
    next_geiger_countup();

#ifdef SD_USE 
    //SD card write gigier.txt
    {
      FILE *fp = fopen("/sd/giger.txt", "a");
      if(fp == NULL) {
        //error("Could not open file for write\n");
        printf("please insert SD");
      }
      else
      {
        sec=time(NULL);
        strftime(buf,40, "%Y/%m/%d %X", localtime(&sec));
        fprintf(fp, "%s %fuSv/h\n",buf,usv);
        fclose(fp);
       }
    }
    
    //SD Card Write raw,txt
    {
      FILE *fp = fopen("/sd/raw.txt", "a");
      if(fp == NULL) {
        printf("please insert SD");
      }
      else
      {

        sec=time(NULL);
        strftime(buf,40, "%Y/%m/%d %X", localtime(&sec));
        fprintf(fp, "%s cpm=%d\n",buf,cpm_array[cpm_index]);
        fclose(fp);
       }

    }
#endif

    //Sleep time for geiger lifetime safe
    wait(SLEEP_SEC);
    waiting=0;
  }
  
  
}

